% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.heterozygosity.r
\name{gl.report.heterozygosity}
\alias{gl.report.heterozygosity}
\title{Reports observed and expected heterozygosity by population or by individual from SNP data.}
\usage{
gl.report.heterozygosity(
  x,
  method = "pop",
  n.invariant = 0,
  plot = TRUE,
  boxplot = "adjusted",
  range = 1.5,
  cex.labels = 0.7,
  verbose = NULL
)
}
\arguments{
\item{x}{-- a genlight object containing the SNP genotypes [Required]}

\item{method}{-- calculate heterozygosity by population (method='pop') or by individual (method='ind') [default 'pop']}

\item{n.invariant}{-- an estimate of the number of invariant sequence tags used to adjust the heterozygosity rate [default 0]}

\item{plot}{-- if TRUE, plots barcharts of observed and expected heterozygosity for populations [TRUE]}

\item{boxplot}{-- if 'standard', plots a standard box and whisker plot; if 'adjusted',
plots a boxplot adjusted for skewed distributions [default 'adjusted']}

\item{range}{-- specifies the range for delimiting outliers [default = 1.5 interquartile ranges]}

\item{cex.labels}{-- sets the size of the population labels [default 0.7]}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2 or as specified using gl.set.verbosity]}
}
\value{
returns a dataframe containing population labels, heterozygosities and sample sizes
}
\description{
Calculates the observed and expected heterozygosities for each population (method="pop") 
or the observed heterozyosity for each individual (method="ind") in a genlight object.
}
\details{
Observed heterozygosity for a population takes the proportion of heterozygous
loci for each individual then averages over the individuals in that population. 
The calculations take into account missing values.

Expected heterozygosity for a population takes the expected proportion of
heterozygotes, that is, expected under Hardy-Weinberg equilibrium, for each locus, then
averages this across the loci for an average estimate for the population.
The calculations of expected heterozygosity use the unbiassed estimates of Nei, M. (1987) 
Molecular evolutionary genetics. New York: Columbia University Press.

Output for method="pop" is an ordered barchart of observed heterozygosity across 
populations together with a table of observed and expected heterozygosity by population.

Observed heterozygosity for individuals is calculated as the proportion of loci that
are heterozygous for that individual.

Output for method="ind" is a histogram of heterozygosity across individuals.
The histogram is accompanied by a box and whisker plot presented either in standard 
(boxplot="standard") or adjusted for skewness (boxplot=adjusted). 

Refer to Tukey (1977, Exploratory Data Analysis. Addison-Wesley) for standard
Box and Whisker Plots and Hubert & Vandervieren (2008), An Adjusted Boxplot for Skewed
Distributions, Computational Statistics & Data Analysis 52:5186-5201) for adjusted
Box and Whisker Plots.

Finally, the loci that are invariant across all individuals in the dataset (that is,
across populations), is typically unknown. This can render estimates of heterozygosity
analysis specific, and so it is not valid to compare such estimates across species
or even across different analyses. This is a similar problem faced by microsatellites.
If you have an estimate of the number of invariant sequence tags (loci) in your data,
such as provided by gl.report.secondaries, you can specify it with the n.invariant
parameter to standardize your estimates of heterozygosity.
}
\examples{
out <- gl.report.heterozygosity(testset.gl,verbose=3)
out <- gl.report.heterozygosity(testset.gl,method='ind',verbose=3)
}
\author{
Bernd Gruber, Arthur Georges and Renee Catullo (Post to \url{https://groups.google.com/d/forum/dartr})
}
