% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.repavg.r
\name{gl.filter.repavg}
\alias{gl.filter.repavg}
\title{Filter loci in a genlight \{adegenet\} object based on average repeatability of alleles at a locus}
\usage{
gl.filter.repavg(x, threshold = 0.99, v = 2)
}
\arguments{
\item{x}{-- name of the genlight object containing the SNP data [required]}

\item{threshold}{-- threshold value below which loci will be removed [default 0.99]}

\item{v}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2]}
}
\value{
Returns a genlight object retaining loci with a RepAvg greater than the specified threshold deleted.
}
\description{
SNP datasets generated by DArT have in index, RepAvg, generated by reproducing the data independently for 30\% of loci.
RepAvg is the proportion of alleles that give a repeatable result, averaged over both alleles for each locus.
}
\examples{
gl.report.repavg(testset.gl)
result <- gl.filter.repavg(testset.gl, threshold=0.95, v=3)
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
