% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl2shp.R
\name{gl2shp}
\alias{gl2shp}
\title{Convert genlight objects to ESRI shapefiles}
\usage{
gl2shp(gl, proj4 = "+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs",
  outfile = "gl", outpath = tempdir(), v = 1)
}
\arguments{
\item{gl}{-- genlight containing lat longs  [required]}

\item{proj4}{-- proj4string of data set. If not provided WGS84 is taken as default. (see spatialreference.org for other projections)}

\item{outfile}{-- name (path) of the output shape file}

\item{outpath}{-- path of the output file. Default is to tempdir(). If to be saved in the current working directory change to "."}

\item{v}{-- verbosity: if v=0 no output, v=1 reports name and path of output file. default 1}
}
\description{
This function exports cordinates in a genlight object to a point shape file (including also individual meta data if available). Coordinates are provided under gl@other$latlong and assumed to be in WGS84 coordinates if no proj4 string is provided.
}
\examples{
gl2shp(testset.gl)
}
\author{
Bernd Guber (glbugs@aerg.canberra.edu.au)
}
