% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.pa.r
\name{gl.report.pa}
\alias{gl.report.pa}
\title{Report number of private alleles possessed by an individual of unknown provenance}
\usage{
gl.report.pa(gl, id, nmin = 10, t = 0)
}
\arguments{
\item{gl}{-- name of the input genlight object [required]}

\item{id}{-- identity label of the focal individual whose provenance is unknown [required]}

\item{nmin}{-- minimum sample size for a target population to be included in the analysis [default 10]}

\item{t}{-- populations to retain in the output genlight object; those for which the focal individual has less than or equal to t loci with private alleles [default 0]}
}
\value{
A genlight object containing the focal individual (assigned to population "unknown") and 
populations for which the focal individual is not distinctive (number of loci with private alleles less than or equal to thresold t.
}
\description{
This script calculates the number of private alleles possessed by a focal individual of unknown
provenance when compared to a series of target populations.
}
\examples{
# Test run with a focal individual from the Macleay River (EmmacMaclGeor)
x <- gl.report.pa(testset.gl, id="UC_00146", nmin=10, t=1)

}
\author{
Arthur Georges (glbugs@aerg.canberra.edu.au)
}
