% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.is.fixed.r
\name{utils.is.fixed}
\alias{utils.is.fixed}
\title{An internal function to tests if two populations are fixed at a given locus}
\usage{
utils.is.fixed(s1, s2, tloc = 0)
}
\arguments{
\item{s1}{Percentage SNP allele or sequence tag frequency for the first 
population [required].}

\item{s2}{Percentage SNP allele or sequence tag frequency for the second 
population [required].}

\item{tloc}{Threshold value for tolerance in when a difference is regarded as
fixed [default 0].}
}
\value{
TRUE (fixed difference) or FALSE (alleles shared) or NA (one or both s1 or s2 missing)
}
\description{
WARNING: UTILITY SCRIPTS ARE FOR INTERNAL USE ONLY AND SHOULD NOT BE USED BY END USERS AS THEIR USE OUT OF CONTEXT COULD LEAD TO UNPREDICTABLE OUTCOMES.
}
\details{
This script compares two percent allele frequencies
and reports TRUE if they represent a fixed difference, FALSE otherwise.

 A fixed difference at a locus occurs when two populations share no alleles,
 noting that SNPs are biallelic (ploidy=2).
Tolerance in the definition of a fixed difference is provided by the t
 parameter. For example, t=0.05 means that SNP allele frequencies of 95,5 and
 5,95 percent will be reported as fixed (TRUE).
}
\seealso{
\code{\link{gl.fixed.diff}}

Other utilities: 
\code{\link{gl.alf}()},
\code{\link{utils.check.datatype}()},
\code{\link{utils.dart2genlight}()},
\code{\link{utils.dist.binary}()},
\code{\link{utils.flag.start}()},
\code{\link{utils.hamming}()},
\code{\link{utils.het.pop}()},
\code{\link{utils.impute}},
\code{\link{utils.jackknife}()},
\code{\link{utils.n.var.invariant}()},
\code{\link{utils.plot.save}()},
\code{\link{utils.read.fasta}()},
\code{\link{utils.read.ped}()},
\code{\link{utils.recalc.avgpic}()},
\code{\link{utils.recalc.callrate}()},
\code{\link{utils.recalc.freqhets}()},
\code{\link{utils.recalc.freqhomref}()},
\code{\link{utils.recalc.freqhomsnp}()},
\code{\link{utils.recalc.maf}()},
\code{\link{utils.reset.flags}()},
\code{\link{utils.transpose}()},
\code{\link{utils.vcfr2genlight.polyploid}()}
}
\author{
Maintainer: Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
\concept{utilities}
