% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.tree.fitch.r
\name{gl.tree.fitch}
\alias{gl.tree.fitch}
\title{Generates a distance phylogeny}
\usage{
gl.tree.fitch(
  D,
  x = NULL,
  phylip.path,
  out.path = tempdir(),
  tree.method = "FM",
  outgroup = NULL,
  global.rearrange = FALSE,
  randomize = FALSE,
  n.jumble = 9,
  bstrap = 1,
  plot.type = "phylogram",
  bstrap.threshold = 0.8,
  branch.width = 2,
  branch.color = "blue",
  node.label.color = "red",
  terminal.label.cex = 0.8,
  node.label.cex = 0.8,
  offset = 1.2,
  verbose = NULL
)
}
\arguments{
\item{D}{Name of the distance matrix for tree building [required]}

\item{x}{Name of the genlight object containing the SNP data [required for bootstrapping, default NULL].}

\item{phylip.path}{Path to the directory that holds the Phylip executables [required].}

\item{out.path}{Path to the directory to save files produced by the analysis [default tempdir()]}

\item{tree.method}{Algorithm used for constructing trees and selecting the best tree [default "FM"]}

\item{outgroup}{Name of the outgroup taxon [default NULL, no outgroup, tree not rooted]}

\item{global.rearrange}{If TRUE, undertake global rearrangements when generating the tree [default FALSE].}

\item{randomize}{If TRUE, randomize the order of the input taxa [default FALSE].}

\item{n.jumble}{Number of randomizations of the input order, must be odd [default 9]}

\item{bstrap}{Number of bootstrap replicates [default 1000]}

\item{plot.type}{One of 'phylogram','cladogram','unrooted','fan','tidy','radial' [default "phylogram"]}

\item{bstrap.threshold}{Threshold for bootstrap values to be displayed on the tree [default 0.8]}

\item{branch.width}{Width of the branches [default 2]}

\item{branch.color}{Colour of the branches [default "blue"]}

\item{node.label.color}{Colour of the node labels [default "red"]}

\item{terminal.label.cex}{Height of the taxon label text [default 0.8]}

\item{node.label.cex}{Height of the node label text [default 0.8]}

\item{offset}{Horizontal offset of the node labels from the node [default 1.8]}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
The tree file in newick format.
}
\description{
Generates a distance phylogeny from a distance object
 using the Fitch-Margoliash algorithm in Phylip.
}
\details{
The script takes a distance object as input. This distance object is typically created with gl.dist.phylo().
The script then creates a file consistent with what is expected
by program fitch in the Phylip suite of executables. It then runs fitch to generate the "best" phylogenetic
tree. Program fitch is run again with bstrap replicates to generate bootstrap support for each node
in the tree and plots these on the tree.

     tree.method : Currently only Fitch-Margoliash is implemented.
     
     outgroup : Name the taxon to be used as outgroup. Must be among the names of the populations defined in the genlight object.
}
\examples{

\dontrun{
tmp <- gl.filter.monomorphs(testset.gl)
gl.phylip(x=tmp,phylip.path="D:/workspace/R/phylip-3.695/exe",plot.type="unrooted",
node.label.cex=0.5,terminal.label.cex=0.6,global.rearrange = FALSE, bstrap=100)
}


}
\seealso{
Other phylogeny: 
\code{\link{gl.dist.phylo}()}
}
\author{
Custodian: Arthur Georges -- Post to 
\url{https://groups.google.com/d/forum/dartr}
}
\concept{phylogeny}
