% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.DArch}
\alias{plot.DArch}
\title{Plot \code{\linkS4class{DArch}} statistics or structure.}
\usage{
\method{plot}{DArch}(x, y = "raw", ..., type = y)
}
\arguments{
\item{x}{\code{\linkS4class{DArch}} instance.}

\item{y}{See \code{type}.}

\item{...}{Additional parameters, passed to plotting functions.}

\item{type}{Which type of plot to create, one of \code{raw},
\code{class}, \code{time}, \code{momentum}, and \code{net}.}
}
\value{
The plotted graph.
}
\description{
This function provides different plots depending on the \code{type}
parameter:
}
\details{
\itemize{
 \item raw. Plots the raw network error (e.g. MSE), this is the default
 \item class. Plots the classification error
 \item time. Plots the times needed for each epoch
 \item momentum. Plots the momentum ramp
 \item net. Calls \code{\link[NeuralNetTools]{plotnet}} to plot the network
}
}
\examples{
\dontrun{
data(iris)
model <- darch(Species ~ ., iris)
plot(model)
plot(model, "class")
plot(model, "time")
plot(model, "momentum")
plot(model, "net")
}
}
\seealso{
Other darch interface functions: \code{\link{darchBench}},
  \code{\link{darchTest}}, \code{\link{darch}},
  \code{\link{predict.DArch}}, \code{\link{print.DArch}}
}

