% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dann.R
\name{dann}
\alias{dann}
\title{Discriminant Adaptive Nearest Neighbor Classification}
\usage{
dann(xTrain, yTrain, xTest, k = 5,
  neighborhood_size = max(floor(nrow(xTrain)/5), 50), epsilon = 1,
  probability = FALSE)
}
\arguments{
\item{xTrain}{Train features. Something easily converted to a numeric matrix.
Generally columns should have mean zero and standard deviation one beforehand.}

\item{yTrain}{Train classes. Something easily converted to a numeric vector.}

\item{xTest}{Test features. Something easily converted to a numeric matrix.
Generally columns should be centered and scaled according to xTrain beforehand.}

\item{k}{The number of data points used for final classification.}

\item{neighborhood_size}{The number of data points used to calculate between and within class covariance.}

\item{epsilon}{Diagonal elements of a diagonal matrix. 1 is the identity matrix.}

\item{probability}{Should probabilities instead of classes be returned?}
}
\value{
A numeric vector containing predicted class or a numeric matrix containing class probabilities.
}
\description{
Discriminant Adaptive Nearest Neighbor Classification
}
\details{
This is an implementation of Hastie and Tibshirani's
\href{https://web.stanford.edu/~hastie/Papers/dann_IEEE.pdf}{Discriminant Adaptive Nearest
Neighbor Classification publication.}.
The code is a port of Christopher Jenness's
python \href{https://github.com/christopherjenness/ML-lib}{implementation.}
}
\examples{
library(dann)
library(mlbench)
library(magrittr)
library(dplyr)
library(ggplot2)

######################
# Circle Data
######################
set.seed(1)
train <- mlbench.circle(300, 2) \%>\%
  tibble::as_tibble()
colnames(train) <- c("X1", "X2", "Y")

ggplot(train, aes(x = X1, y = X2, colour = Y)) +
  geom_point() +
  labs(title = "Train Data")

xTrain <- train \%>\%
  select(X1, X2) \%>\%
  as.matrix()

yTrain <- train \%>\%
  pull(Y) \%>\%
  as.numeric() \%>\%
  as.vector()

test <- mlbench.circle(100, 2) \%>\%
  tibble::as_tibble()
colnames(test) <- c("X1", "X2", "Y")

ggplot(test, aes(x = X1, y = X2, colour = Y)) +
  geom_point() +
  labs(title = "Test Data")

xTest <- test \%>\%
  select(X1, X2) \%>\%
  as.matrix()

yTest <- test \%>\%
  pull(Y) \%>\%
  as.numeric() \%>\%
  as.vector()

dannPreds <- dann(
  xTrain = xTrain, yTrain = yTrain, xTest = xTest,
  k = 3, neighborhood_size = 50, epsilon = 1,
  probability = FALSE
)
mean(dannPreds == yTest) # An accurate model.

rm(train, test)
rm(xTrain, yTrain)
rm(xTest, yTest)
rm(dannPreds)
}
