% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventClass.R
\name{eventlist}
\alias{eventlist}
\alias{addEvent}
\title{Eventlist}
\usage{
eventlist(var = NULL, time = NULL, value = NULL, method = NULL)

addEvent(event, var, time = 0, value = 0, method = "replace", ...)
}
\arguments{
\item{var}{Character, the state to which the event is applied}

\item{time}{Character or Numeric, the time at which the event happens}

\item{value}{Character or Numeric, the value of the event}

\item{method}{Character, options are "replace", "add" or "multiply"}

\item{event}{object of class \code{eventlist}}

\item{...}{not used}
}
\value{
data.frame with class eventlist
}
\description{
An eventlist is a data.frame with the necessary parameters to define an event as columns and specific events as rows.
Event time and value can be passed as parameters, which can also be estimated.
}
\details{
The function \code{addEvent} is pipe-friendly
}
\examples{
eventlist(var = "A", time = "5", value = 1, method = "add")

events <- addEvent(NULL, var = "A", time = "5", value = 1, method = "add")
events <- addEvent(events, var = "A", time = "10", value = 1, method = "add")
}
