% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\name{P}
\alias{P}
\title{Generate a parameter transformation function}
\usage{
P(trafo = NULL, parameters = NULL, condition = NULL,
  attach.input = FALSE, keep.root = TRUE, compile = FALSE,
  modelname = NULL, method = c("explicit", "implicit"), verbose = FALSE)
}
\arguments{
\item{trafo}{object of class \code{eqnvec} or named character or list thereof. In case,
trafo is a list, \code{P()} is called on each element and conditions are assumed to be
the list names.}

\item{parameters}{character vector}

\item{condition}{character, the condition for which the transformation is generated}

\item{attach.input}{attach those incoming parameters to output which are not overwritten by
the parameter transformation.}

\item{keep.root}{logical, applies for \code{method = "implicit"}. The root of the last
evaluation of the parameter transformation function is saved as guess for the next 
evaluation.}

\item{compile}{logical, compile the function (see \link{funC0})}

\item{modelname}{character, see \link{funC0}}

\item{method}{character, either \code{"explicit"} or \code{"implicit"}}

\item{verbose}{Print out information during compilation}
}
\value{
An object of class \link{parfn}.
}
\description{
Generate parameter transformation function from a
named character vector or object of class \link{eqnvec}. This is a wrapper
function for \link{Pexpl} and \link{Pimpl}. See for more details there.
}
