% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{odemodel}
\alias{odemodel}
\title{Generate the model objects for use in Xs (models with sensitivities)}
\usage{
odemodel(f, deriv = TRUE, forcings = NULL, fixed = NULL,
  modelname = "odemodel", gridpoints = NULL, verbose = FALSE, ...)
}
\arguments{
\item{f}{Something that can be converted to \link{eqnvec}, 
e.g. a named character vector with the ODE}

\item{deriv}{logical, generate sensitivities or not}

\item{forcings}{Character vector with the names of the forcings}

\item{fixed}{Character vector with the names of parameters (initial values and dynamic) for which
no sensitivities are required (will speed up the integration).}

\item{modelname}{Character, the name of the C file being generated.}

\item{gridpoints}{Integer, the minimum number of time points where the ODE is evaluated internally}

\item{verbose}{Print compiler output to R command line.}

\item{...}{Further arguments being passed to funC.}
}
\value{
list with \code{func} (ODE object) and \code{extended} (ODE+Sensitivities object)
}
\description{
Generate the model objects for use in Xs (models with sensitivities)
}
\examples{
\dontrun{

## Generate a compiled ODE model from an equation vector
## The model will not return sensitivities for "switch"
## Files will be generated in your working directory!

f <- eqnvec(A = "-k*A + switch*F")
model <- odemodel(f, forcings = "F", fixed = "switch")
print(model)

## Generate the same model from an equation list
f <- addReaction(NULL, from = "", to = "A", rate = "switch*F", description = "production")
f <- addReaction(f   , from = "A", to = "", rate = "k*A", description = "degradation")
print(f)

model <- odemodel(f, forcings = "F", fixed = "switch")
print(model)

}
}

