% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/generateEquations.R
\name{subset.eqnList}
\alias{subset.eqnList}
\title{subset of an equation list}
\usage{
\method{subset}{eqnList}(x, ...)
}
\arguments{
\item{x}{the equation list}

\item{...}{logical expression for subsetting}
}
\value{
An object of class \code{eqnList}, a named vector with the equations. Contains attributes "SMatrix"
(the stoichiometric matrix), "species" (the state names), "rates" (the rate expressions) and "description".
}
\description{
subset of an equation list
}
\details{
The argument \code{...} can contain "Educt", "Product", "Rate" and "Description".
The "%in%" operator is modified to allow searches in Educt and Product (see examples).
}
\examples{
reactions <- data.frame(Description = c("Activation", "Deactivation"),
                        Rate = c("act*A", "deact*pA"), A=c(-1,1), pA=c(1, -1) )
f <- generateEquations(reactions)
subset(f, "A"\%in\%Educt)
subset(f, "pA"\%in\%Product)
subset(f, grepl("act", Rate))
}

