% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{po_treemap}
\alias{po_treemap}
\title{Treemap}
\usage{
po_treemap(d3po, ..., data = NULL, inherit_daes = TRUE)
}
\arguments{
\item{d3po}{Either the output of \code{\link[=d3po]{d3po()}} or \code{\link[=d3po_proxy]{d3po_proxy()}}.}

\item{...}{Aesthetics, see \code{\link[=daes]{daes()}}.}

\item{data}{Any dataset to use for plot, overrides data passed
to \code{\link[=d3po]{d3po()}}.}

\item{inherit_daes}{Whether to inherit aesthetics previous specified.}
}
\value{
an 'htmlwidgets' object with the desired interactive plot
}
\description{
Plot a treemap
}
\examples{
if (interactive()) {
  trade_by_continent <- d3po::trade[d3po::trade$year == 2023L, ]
  trade_by_continent <- aggregate(trade ~ reporter_continent, data = trade_by_continent, FUN = sum)

  my_pal <- tintin::tintin_pal(option = "The Secret of the Unicorn")(7)

  names(my_pal) <- c(
    "Africa", "Antarctica", "Asia",
    "Europe", "North America", "Oceania", "South America"
  )

  d3po(trade_by_continent, width = 800, height = 600) \%>\%
    po_treemap(daes(
      size = trade, group = reporter_continent,
      color = my_pal, tiling = "Squarify"
    )) \%>\%
    po_labels(title = "Trade Share by Continent in 2023")
}
}
