% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_random_projection.R
\name{generate_component_matrix}
\alias{generate_component_matrix}
\title{A sparse matrix for sparse random projection.}
\usage{
generate_component_matrix(n_features, n_components, density)
}
\arguments{
\item{n_features}{the dimensionality of the original space.}

\item{n_components}{the dimensionality of the projected space.}

\item{density}{the density of the sparse random matrix.}
}
\value{
A sparse random matrix of size \code{(n_features, n_components)}.
}
\description{
\code{generate_component_matrix} generates the sparse random component matrix
for performing sparse random projection. If \code{density} is the density of
the sparse matrix and \code{n_components} is the size of the projected space,
the elements of the random matrix are drawn from
}
\details{
\code{-sqrt(1 / (density * n_components))} with probability \code{density / 2}
    \code{0}                                   with probability \code{1 - density}
    \code{sqrt(1 / (density * n_components))}  with probability \code{density / 2}
}
\examples{
generate_component_matrix(500, 100, 0.3)
}
