% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_cop_mle.R
\name{optML}
\alias{optML}
\title{Estimate Parameters of a Circular-Linear Copula According to Maximum Likelihood}
\usage{
optML(
  copula,
  theta,
  x,
  parameters,
  start,
  lower = NULL,
  upper = NULL,
  optim.method = "L-BFGS-B",
  optim.control = list(maxit = 100),
  estimate.variance = FALSE,
  traceOpt = FALSE
)
}
\arguments{
\item{copula}{\R object of class '\code{\linkS4class{cyl_copula}}'.}

\item{theta}{\link[base]{numeric} \link[base]{vector} of angles
(measurements of a circular variable).}

\item{x}{\link[base]{numeric} \link[base]{vector} of step lengths
(measurements of a linear variable).}

\item{parameters}{\link[base]{vector} of \link[base]{character} strings
holding the names of the parameters to be optimized.
  These can be any parameters in \code{copula@parameters}.}

\item{start}{\link[base]{vector} of staring values of the parameters.}

\item{lower}{OPTIONAL: \link[base]{vector} of lower bounds of the parameters.}

\item{upper}{OPTIONAL: \link[base]{vector} of upper bounds of the parameters.}

\item{optim.method}{\link[base]{character} string, optimizer used in
\code{\link[stats]{optim}()}, can be
 \code{"Nelder-Mead"}, \code{"BFGS"}, \code{"CG"}, \code{"L-BFGS-B"},
 \code{"SANN"}, or \code{"Brent"}.}

\item{optim.control}{\link[base]{list} of additional controls passed to
\code{\link[stats]{optim}()}.}

\item{estimate.variance}{\link[base]{logical} value, denoting whether to include an
estimate of the variance (NOT YET IMPLEMENTED).}

\item{traceOpt}{\link[base]{logical} value, whether to print information regarding
convergence, current values, etc. during the optimization process.}
}
\value{
A list of length 3 containing the same type of '\code{\linkS4class{cyl_copula}}'
 object as \code{copula}, but with optimized parameters, the log-likelihood
 and the AIC.
}
\description{
The code of this function is based on \code{copula::\link[copula]{fitCopula}()}.
A circular-linear copula is fit to a set of bivariate observations.
}
\examples{
set.seed(123)

#optimization of copula is independent of the marginals
sample <- rcylcop(100,cyl_quadsec(0.1))
optML(copula = cyl_quadsec(),
  theta = sample[,1],
  x = sample[,2],
  parameters = "a",
  start = 0
)
optML(copula = cyl_rect_combine(copula::frankCopula()),
  theta = sample[,1],
  x = sample[,2],
  parameters = "alpha",
  start = 1
)

}
\references{
\insertRef{Hodelappl}{cylcop}

\insertRef{Hodelmethod}{cylcop}
}
\seealso{
\code{copula::\link[copula]{fitCopula}()}, \code{\link{optCor}()},
 \code{\link{optML}()}, \code{\link{opt_auto}()}.
}
