% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_param.R
\name{set_param}
\alias{set_param}
\alias{set_param,EffectScenario,vector-method}
\alias{set_param,EffectScenario,parameter_set-method}
\alias{set_param,list,parameter_set-method}
\alias{set_param,list,vector-method}
\alias{set_param,ScenarioSequence,vector-method}
\alias{set_param,ScenarioSequence,parameter_set-method}
\title{Set model parameters}
\usage{
set_param(x, param)

\S4method{set_param}{EffectScenario,vector}(x, param)

\S4method{set_param}{EffectScenario,parameter_set}(x, param)

\S4method{set_param}{list,parameter_set}(x, param)

\S4method{set_param}{list,vector}(x, param)

\S4method{set_param}{ScenarioSequence,vector}(x, param)

\S4method{set_param}{ScenarioSequence,parameter_set}(x, param)
}
\arguments{
\item{x}{object(s) to modify}

\item{param}{named numeric \code{vector} with parameter names and value OR a
list of \linkS4class{parameter_set} objects}
}
\value{
Vector of modified objects
}
\description{
Modifies the parameters of one or more \code{EffectScenario} objects.
}
\details{
Most parameters are represented by numerical types but other types
are possible depending on model. Please refer to the model description
which parameters are required and in which unit. Some or all parameters may
be required to start a simulation. If required parameters are missing,
simulation will fail with an error message.
}
\examples{
Lemna_Schmitt() \%>\% set_param(c(Emax=1,EC50=0.12))
}
