% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cut_boot.R
\name{plot_cut_boot}
\alias{plot_cut_boot}
\title{Plot the bootstrapped distribution of optimal cutpoints from a cutpointr object}
\usage{
plot_cut_boot(x, ...)
}
\arguments{
\item{x}{A cutpointr object.}

\item{...}{Additional arguments (unused).}
}
\description{
Given a cutpointr object this function plots the bootstrapped distribution
of optimal cutpoints. \code{cutpointr} has to be run with \code{boot_runs}` > 0
to enable bootstrapping.
}
\examples{
set.seed(100)
opt_cut <- cutpointr(suicide, dsi, suicide, boot_runs = 10)
plot_cut_boot(opt_cut)
}
\seealso{
Other cutpointr plotting functions: 
\code{\link{plot.cutpointr}()},
\code{\link{plot_cutpointr}()},
\code{\link{plot_metric_boot}()},
\code{\link{plot_metric}()},
\code{\link{plot_precision_recall}()},
\code{\link{plot_roc}()},
\code{\link{plot_sensitivity_specificity}()},
\code{\link{plot_x}()}
}
\concept{cutpointr plotting functions}
