% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_subfeatures.R
\encoding{UTF-8}
\name{calculate_subfeatures}
\alias{calculate_subfeatures}
\title{Computes several subfeatures associated with a categorical time series}
\usage{
calculate_subfeatures(series, n_series, categories, lag = 1, type = NULL)
}
\arguments{
\item{series}{A CTS.}

\item{n_series}{A real-valued time series.}

\item{categories}{A vector of type factor containing the corresponding
categories.}

\item{lag}{The considered lag (default is 1).}

\item{type}{String indicating the subfeature one wishes to compute.}
}
\value{
The corresponding subfeature
}
\description{
\code{calculate_features} computes several subfeatures associated with a
categorical time series or between a categorical and a real-valued time series
}
\details{
Assume we have a CTS of length \eqn{T} with range \eqn{\mathcal{V}=\{1, 2, \ldots, r\}},
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, with \eqn{\widehat{p}_i}
being the natural estimate of the marginal probability of the \eqn{i}th
category, and \eqn{\widehat{p}_{ij}(l)} being the natural estimate of the joint probability
for categories \eqn{i} and \eqn{j} at lag l, \eqn{i,j=1, \ldots, r}. Assume also that
we have a real-valued time series of length \eqn{T}, \eqn{\overline{Z}_t=\{\overline{Z}_1,\ldots, \overline{Z}_T\}}.
The function computes the following subfeatures depending on the argument
\code{type}:

\itemize{

  \item{If \code{type=entropy}, the function computes the
   subfeatures associated with the estimated entropy, \eqn{\widehat{p}_i\ln(\widehat{p}_i)},
  \eqn{i=1,2, \ldots,r}}.

  \item{If \code{type=gk_tau}, the function computes the
   subfeatures associated with the estimated Goodman and Kruskal's tau, \eqn{\frac{\widehat{p}_{ij}(l)^2}{\widehat{p}_j}},
   \eqn{i,j=1,2, \ldots,r}}.

  \item{If \code{type=gk_lambda}, the function computes the
   subfeatures associated with the estimated Goodman and Kruskal's lambda, \eqn{\max_i\widehat{p}_{ij}(l)},
  \eqn{i=1,2, \ldots,r}}.

  \item{If \code{type=uncertainty_coefficient}, the function computes the
   subfeatures associated with the estimated uncertainty coefficient, \eqn{\widehat{p}_{ij}(l)\ln\Big(\frac{\widehat{p}_{ij}(l)}{\widehat{p}_i\widehat{p}_j}\Big)},
  \eqn{i,j=1,2, \ldots,r}}.

  \item{If \code{type=pearson_measure}, the function computes the
   subfeatures associated with the estimated Pearson measure, \eqn{\frac{(\widehat{p}_{ij}(l)-\widehat{p}_i\widehat{p}_j)^2}{\widehat{p}_i\widehat{p}_j}},
  \eqn{i,j=1,2, \ldots,r}}.

  \item{If \code{type=phi2_measure}, the function computes the
   subfeatures associated with the estimated Phi2 measure, \eqn{\frac{(\widehat{p}_{ij}(l)-\widehat{p}_i\widehat{p}_j)^2}{\widehat{p}_i\widehat{p}_j}},
  \eqn{i,j=1,2, \ldots,r}}.

  \item{If \code{type=sakoda_measure}, the function computes the
   subfeatures associated with the estimated Sakoda measure, \eqn{\frac{(\widehat{p}_{ij}(l)-\widehat{p}_i\widehat{p}_j)^2}{\widehat{p}_i\widehat{p}_j}},
  \eqn{i,j=1,2, \ldots,r}}.

  \item{If \code{type=cramers_vi}, the function computes the
   subfeatures associated with the estimated Cramer's vi, \eqn{\frac{(\widehat{p}_{ij}(l)-\widehat{p}_i\widehat{p}_j)^2}{\widehat{p}_i\widehat{p}_j}},
  \eqn{i,j=1,2, \ldots,r}}.

  \item{If \code{type=cohens_kappa}, the function computes the
   subfeatures associated with the estimated Cohen's kappa, \eqn{\widehat{p}_{ii}(l)-\widehat{p}_i^2},
  \eqn{i=1,2, \ldots,r}}.

  \item{If \code{type=total_correlation}, the function computes the
   subfeatures associated with the total correlation, \eqn{\widehat{\psi}_{ij}(l)},
   \eqn{i,j=1,2, \ldots,r} (see \code{type='total_mixed_cor'} in the function \code{calculate_features})}.

  \item{If \code{type=total_mixed_correlation_1}, the function computes the
   subfeatures associated with the total mixed l-correlation, \eqn{\widehat{\psi}_{i}(l)},
  \eqn{i=1,2, \ldots,r} (see \code{type='total_mixed_correlation_1'} in the function \code{calculate_features})}.

  \item{If \code{type=total_mixed_correlation_2}, the function computes the
   subfeatures associated with the total mixed q-correlation, \eqn{\int_{0}^{1}\widehat{\psi}^\rho_{i}(l)^2d\rho},
   \eqn{i=1,2, \ldots,r} (see \code{type='total_mixed_correlation_2'} in the function \code{calculate_features})}.

}
}
\examples{
suc <- calculate_subfeatures(series = GeneticSequences$data[[1]],
categories = factor(c('a', 'c', 'g', 't')), type = 'uncertainty_coefficient' )
# Computing the subfeatures associated with the uncertainty coefficient
# for the first series in dataset GeneticSequences
scv <- calculate_subfeatures(series = GeneticSequences$data[[1]],
categories = factor(c('a', 'c', 'g', 't')), type = 'cramers_vi' )
# Computing the subfeatures associated with the cramers vi
# for the first series in dataset GeneticSequences
}
\references{
{

  \insertRef{weiss2008measuring}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
