% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phi2_measure.R
\encoding{UTF-8}
\name{phi2_measure}
\alias{phi2_measure}
\title{Computes the Phi2 measure of a categorical time series}
\usage{
phi2_measure(series, lag = 1, categories, features = FALSE)
}
\arguments{
\item{series}{A CTS.}

\item{lag}{The considered lag (default is 1).}

\item{categories}{A vector of type factor containing the corresponding
categories.}

\item{features}{Logical. If \code{features = FALSE} (default), the value of the Phi2 measure is returned. Otherwise, the function
returns a matrix with the individual components of the Phi2 measure.}
}
\value{
If \code{features = FALSE} (default), returns the value of the Phi2 measure. Otherwise, the function
returns a matrix of features, i.e., the matrix contains the features employed to compute the
Phi2 measure.
}
\description{
\code{phi2_measure} returns the value of the Phi2 measure for
a categorical time series
}
\details{
Given a CTS of length \eqn{T} with range \eqn{\mathcal{V}=\{1, 2, \ldots, r\}},
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, the function computes the
estimated Phi2 measure, \eqn{\widehat{\Phi}^2(l)=\frac{\widehat{X}_T^2(l)}{T}},
where \eqn{\widehat{X}_T^2} is the estimated Pearson measure. If \code{features = TRUE}, the function
returns the same output as the function \code{\link{pearson_measure}}.
}
\examples{
phi2m <- phi2_measure(series = GeneticSequences$data[[1]],
categories = factor(c('a', 'c', 'g', 't'))) # Computing the Phi2 measure
# for the first series in dataset GeneticSequences
feature_matrix <- phi2_measure(series = GeneticSequences$data[[1]],
categories = factor(c('a', 'c', 'g', 't')), features = TRUE) # Computing the corresponding
# matrix of features
}
\references{
{

  \insertRef{weiss2008measuring}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
