% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gk_tau.R
\encoding{UTF-8}
\name{gk_tau}
\alias{gk_tau}
\title{Computes the Goodman and Kruskal's tau of a categorical time series}
\usage{
gk_tau(series, lag = 1, categories, features = FALSE)
}
\arguments{
\item{series}{A CTS.}

\item{lag}{The considered lag (default is 1).}

\item{categories}{A vector of type factor containing the corresponding
categories.}

\item{features}{Logical. If \code{features = FALSE} (default), the value of Goodman and Kruskal's tau is returned. Otherwise, the function
returns a matrix with the individual components of Goodman and Kruskal's tau.}
}
\value{
If \code{features = FALSE} (default), returns the value of the Goodman and Kruskal's tau. Otherwise, the function
returns a matrix of features, i.e., the matrix contains the features employed to compute the
Goodman and Kruskal's tau.
}
\description{
\code{gk_tau} returns the value of the Goodman and Kruskal's tau for
a categorical time series
}
\details{
Given a CTS of length \eqn{T} with range \eqn{\mathcal{V}=\{1, 2, \ldots, r\}},
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, the function computes the
estimated Goodman and Kruskal's tau, \eqn{\widehat{\tau}(l)=\frac{\sum_{i,j=1}^{r}\frac{\widehat{p}_{ij}(l)^2}{\widehat{p}_j}-\sum_{i=1}^r\widehat{p}_i^2}{1-\sum_{i=1}^r\widehat{p}_i^2}},
where \eqn{\widehat{p}_i} is the natural estimate of the marginal probability of the \eqn{i}th
category, and \eqn{\widehat{p}_{ij}(l)} is the natural estimate of the joint probability
for categories \eqn{i} and \eqn{j} at lag l, \eqn{i,j=1, \ldots, r}. If \code{features = TRUE}, the function
returns a matrix whose components are the quantities \eqn{\frac{\widehat{p}_{ij}(l)^2}{\widehat{p}_j}},
\eqn{i,j=1,2, \ldots,r}.
}
\examples{
gkt <- gk_tau(series = GeneticSequences$data[[1]],
categories = factor(c('a', 'c', 'g', 't'))) # Computing the Goodman and Kruskal's tau
# for the first series in dataset GeneticSequences
feature_matrix <- gk_tau(series = GeneticSequences$data[[1]],
categories = factor(c('a', 'c', 'g', 't')), features = TRUE) # Computing the corresponding
# matrix of features
}
\references{
{

  \insertRef{weiss2008measuring}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
