% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctFitAuto.R
\name{ctFitAutoGroupModel}
\alias{ctFitAutoGroupModel}
\title{ctFitAutoGroupModel}
\usage{
ctFitAutoGroupModel(
  m,
  dat,
  cores,
  DRIFT = TRUE,
  DIFFUSION = TRUE,
  groupFreeThreshold = 0.5,
  ...
)
}
\arguments{
\item{m}{ctStan model object without time independent predictors.}

\item{dat}{Data in long format}

\item{cores}{Number of CPU cores to use}

\item{DRIFT}{Logical, if TRUE, off diagonal drift parameters in the model are tested for inclusion}

\item{DIFFUSION}{Logical, if TRUE, off diagonal diffusion parameters in the model are tested for inclusion}

\item{groupFreeThreshold}{Numeric, threshold for group free parameter selection. Default is .5}

\item{...}{Additional arguments passed to ctStanFit}
}
\value{
A list containing a list of ctStan fit objects for each subject, and a group model
}
\description{
Fit a ctStan model with automatic parameter selection for multiple subjects
}
\details{
This function is used to automatically select parameters in a ctStan model. Any specified DRIFT / DIFFUSION matrix off diagonals are only included if they significantly improve the likelihood, based on an estimated likelihood ratio test (relying on the Hessian). Subjects are fit one by one, and a group model is determined based on the groupFreeThreshold parameter -- when the proportion of subjects with a parameter free is above this threshold, the parameter is freed in the group model.
}
\examples{
\dontrun{
testmodel <- ctstantestfit$ctstanmodelbase
testmodel$pars$TI1_effect <- NULL
testmodel$n.TIpred <- 0
testmodel$TIpredNames <- NULL
testfit <- ctFitAutoGroupModel(testmodel, 
dat = ctstantestdat, cores=2, DRIFT = TRUE, DIFFUSION = TRUE)
ctModelLatex(testfit$groupModel)
lapply(testfit$fits,function(x) print(ctStanContinuousPars(x)$DRIFT))
}
}
