% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ctrGetQueryUrl}
\alias{ctrGetQueryUrl}
\title{Get query details}
\usage{
ctrGetQueryUrl(url = "", register = "")
}
\arguments{
\item{url}{URL such as from the browser address bar.
If not specified, clipboard contents will be checked for
a suitable URL. Can also contain a query term such as from
\link{dbQueryHistory}()["query-term"]}

\item{register}{Optional name of register (i.e., "EUCTR" or
"CTGOV") in case url is a query term}
}
\value{
A data frame (or tibble, if \code{dplyr} is loaded)
with column names `query-term` and `query-register`.
The data frame (or tibble) can be passed as such as parameter
`query-term` to \link{ctrLoadQueryIntoDb} and as parameter
`url` to \link{ctrOpenSearchPagesInBrowser}.
}
\description{
Extracts query parameters and register name from parameter `url` or
from the clipboard, into which the URL of a register search was copied.
}
\examples{

\dontrun{

dbc <- nodbi::src_sqlite(collection = "my_collection")

# user now copies into the clipboard the URL from
# the address bar of the browser that shows results
# from a query in one of the trial registers
#
# information about all trials found with this query
# is now loaded into the database collection
ctrLoadQueryIntoDb(
  queryterm = ctrGetQueryUrl(),
  con = dbc
)

}

}
