% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mutations_read_names.R
\name{get_mutations_read_names}
\alias{get_mutations_read_names}
\title{Gets names of the reads showing reference and alternative allele of a list of mutations}
\usage{
get_mutations_read_names(bam, mutations, min_base_quality = 20,
  tag = "", min_mapq = 30)
}
\arguments{
\item{bam}{path to bam file}

\item{mutations}{A data frame containing the mutations. Must have the columns CHROM, POS, REF, ALT.}

\item{min_base_quality}{integer specifying the minimum base quality for reads to be included.}

\item{tag}{the RG tag if the bam has more than one sample}

\item{min_mapq}{integer specifying the minimum mapping quality for reads to be included}
}
\value{
A list with length equal to the number of mutations. Each element is a character vector with the read names.
}
\description{
This function extracts the names of the reads in a bam file that support the variant and reference alleles of the input mutations
}
\details{
Returns the IDs of the read that cover the input mutations (ref and alt alleles).
}
\examples{
data("mutations", package = "ctDNAtools")
bamT1 <- system.file("extdata", "T1.bam", package = "ctDNAtools")
get_mutations_read_names(bam = bamT1, mutations = mutations[1:3, ])
}
\seealso{
\code{\link{get_mutations_read_counts}} \code{\link{get_mutations_fragment_size}} \code{\link{test_ctDNA}}
}
