% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cso_get_meta.R
\name{cso_get_interval}
\alias{cso_get_interval}
\title{Returns a the time interval used to record data in a CSO table}
\usage{
cso_get_interval(table_code, cache_data = TRUE)
}
\arguments{
\item{table_code}{string. A valid code for one table from the
StatBank.}

\item{cache_data}{logical. Whether to use cached data, if available.
Default value is TRUE. Strongly recommended to use caching, as otherwise
the entire table could be downloaded only to access a small part of its
metadata.}
}
\value{
character vector. The names of the statistics included in the
table, with one element for each statistic.
}
\description{
Reads the metadata of a table to return an atomic character vector
displaying the intervals at which the data included in the table was
gathered/calculated.
}
\examples{
cso_get_interval("C0636")
}
