/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

public class SimpleStringEncrypter {
    private static final String INVALID_CODE_STRING_MSG = "Invalid code string";
    private static String codeSymbols = "ABCDEFGHIJKLMNOPabcdefghijklmnopQRSTUVWXYZ012345qrstuvwxyz6789@$";

    public String encrypt(String clearText) {
        char[] code = new char[clearText.length() * 2];
        for (int i = 0; i < clearText.length(); ++i) {
            char c = clearText.charAt(i);
            this.setEncryptedSymbol(c, code, 2 * i);
        }
        return new String(code);
    }

    public void setEncryptedSymbol(char c, char[] code, int i) {
        char charVal = c;
        int nibble0 = charVal & 0xF;
        int nibble1 = charVal >> 4;
        code[i] = this.encodeNibble(nibble0);
        code[i + 1] = this.encodeNibble(nibble1);
    }

    private char encodeNibble(int val) {
        int random4 = (int)(4.0 * Math.random());
        int randomOffset = 16 * random4;
        return codeSymbols.charAt(val + randomOffset);
    }

    public String decrypt(String codeText) {
        if (codeText.length() % 2 != 0) {
            throw new IllegalArgumentException(INVALID_CODE_STRING_MSG);
        }
        char[] clear = new char[codeText.length() / 2];
        for (int i = 0; i < codeText.length() / 2; ++i) {
            char symbol0 = codeText.charAt(2 * i);
            char symbol1 = codeText.charAt(2 * i + 1);
            clear[i] = this.decryptedChar(symbol0, symbol1);
        }
        return new String(clear);
    }

    private char decryptedChar(char symbol0, char symbol1) {
        int nibble0 = this.decodeNibble(symbol0);
        int nibble1 = this.decodeNibble(symbol1);
        int charVal = nibble1 << 4 | nibble0;
        return (char)charVal;
    }

    private int decodeNibble(int symbolValue) {
        int nibbleValue = codeSymbols.indexOf(symbolValue);
        if (nibbleValue < 0) {
            throw new IllegalArgumentException(INVALID_CODE_STRING_MSG);
        }
        return nibbleValue % 16;
    }
}

