/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.io.datasource;

import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.JUMPReader;
import com.vividsolutions.jump.io.JUMPWriter;
import com.vividsolutions.jump.io.datasource.Connection;
import com.vividsolutions.jump.io.datasource.DataSource;
import com.vividsolutions.jump.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class ReaderWriterFileDataSource
extends DataSource {
    protected JUMPReader reader;
    protected JUMPWriter writer;

    public ReaderWriterFileDataSource(JUMPReader reader, JUMPWriter writer) {
        this.reader = reader;
        this.writer = writer;
    }

    public Connection getConnection() {
        return new Connection(){

            public FeatureCollection executeQuery(String query, Collection exceptions, TaskMonitor monitor) {
                try {
                    return ReaderWriterFileDataSource.this.reader.read(ReaderWriterFileDataSource.this.getReaderDriverProperties());
                }
                catch (Exception e) {
                    exceptions.add(e);
                    return null;
                }
            }

            public void executeUpdate(String update, FeatureCollection featureCollection, TaskMonitor monitor) throws Exception {
                ReaderWriterFileDataSource.this.writer.write(featureCollection, ReaderWriterFileDataSource.this.getWriterDriverProperties());
            }

            public void close() {
            }

            public FeatureCollection executeQuery(String query, TaskMonitor monitor) throws Exception {
                ArrayList exceptions = new ArrayList();
                FeatureCollection featureCollection = this.executeQuery(query, exceptions, monitor);
                if (!exceptions.isEmpty()) {
                    throw (Exception)exceptions.iterator().next();
                }
                return featureCollection;
            }
        };
    }

    protected DriverProperties getReaderDriverProperties() {
        return this.getDriverProperties();
    }

    protected DriverProperties getWriterDriverProperties() {
        return this.getDriverProperties();
    }

    private DriverProperties getDriverProperties() {
        DriverProperties properties = new DriverProperties();
        properties.putAll((Map<?, ?>)this.getProperties());
        return properties;
    }
}

