/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.predicate;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.predicate.ContainsPointVisitor;
import com.vividsolutions.jts.operation.predicate.EnvelopeIntersectsVisitor;
import com.vividsolutions.jts.operation.predicate.LineIntersectsVisitor;

public class RectangleIntersects {
    public static final int MAXIMUM_SCAN_SEGMENT_COUNT = 200;
    private Polygon rectangle;
    private Envelope rectEnv;

    public static boolean intersects(Polygon rectangle, Geometry b) {
        RectangleIntersects rp = new RectangleIntersects(rectangle);
        return rp.intersects(b);
    }

    public RectangleIntersects(Polygon rectangle) {
        this.rectangle = rectangle;
        this.rectEnv = rectangle.getEnvelopeInternal();
    }

    public boolean intersects(Geometry geom) {
        if (!this.rectEnv.intersects(geom.getEnvelopeInternal())) {
            return false;
        }
        EnvelopeIntersectsVisitor visitor = new EnvelopeIntersectsVisitor(this.rectEnv);
        visitor.applyTo(geom);
        if (visitor.intersects()) {
            return true;
        }
        ContainsPointVisitor ecpVisitor = new ContainsPointVisitor(this.rectangle);
        ecpVisitor.applyTo(geom);
        if (ecpVisitor.containsPoint()) {
            return true;
        }
        LineIntersectsVisitor liVisitor = new LineIntersectsVisitor(this.rectangle);
        liVisitor.applyTo(geom);
        return liVisitor.intersects();
    }
}

