% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nor_population_by_age_cats.R
\name{nor_population_by_age_cats}
\alias{nor_population_by_age_cats}
\title{Population in Norway by categories}
\usage{
nor_population_by_age_cats(
  cats = NULL,
  include_total = TRUE,
  include_9999 = FALSE,
  border = csdata::config$border_nor
)
}
\arguments{
\item{cats}{A list containing vectors that you want to categorize.}

\item{include_total}{Boolean. Should 'total' be included as an age cat?}

\item{include_9999}{Boolean. Should the current year is duplicated and added as "calyear==9999".
This is in accordance with the cstidy principles regarding granularity_time=="event_*".}

\item{border}{The year in which Norwegian geographical boundaries were designated (2020, 2024).}
}
\value{
A data.table containing the following columns:
\itemize{
\item granularity_geo
\item location_code
\item age (as specified in the argument "cats")
\item sex ("total")
\item calyear
\item pop_jan1_n
\item imputed
}
}
\description{
A function that easily categorizes the Norwegian population into different age categories.
}
\examples{
nor_population_by_age_cats(cats = list(c(1:10), c(11:20)))
nor_population_by_age_cats(cats = list("one to ten" = c(1:10), "eleven to twenty" = c(11:20)))
nor_population_by_age_cats(cats = list(c(1:10), c(11:20), "021p"=c(21:200)))
}
