## ---- results='hide', echo=FALSE, message=FALSE--------------------------
## Because the vignette tasks require communicating with a remote host,
## we do all the work ahead of time and save a workspace, which we load here.
## We'll then reference saved objects in that as if we had just retrieved them
## from the server
library(crunch)
load("variables.RData")

## ---- eval=FALSE---------------------------------------------------------
#  identical(names(ds), names(df))

## ---- eval=FALSE---------------------------------------------------------
#  track.var <- ds$track
#  track.var

## ---- echo=FALSE---------------------------------------------------------
cat(summary.track.var, sep="\n")

## ---- eval=FALSE---------------------------------------------------------
#  name(track.var) <- "Direction of country"
#  description(track.var) <- "In your opinon, is the country going in the right direction, or is it on the wrong track?"

## ---- eval=FALSE---------------------------------------------------------
#  name(track.var) == name(ds$track)

## ---- eval=FALSE---------------------------------------------------------
#  ## Not run
#  name(ds$track) <- "Direction of country"

## ---- eval=FALSE---------------------------------------------------------
#  ds$track <- track.var

## ---- eval=FALSE---------------------------------------------------------
#  ds <- refresh(ds)

## ---- eval=FALSE---------------------------------------------------------
#  name(track.var) == name(ds$track)

## ------------------------------------------------------------------------
class(variables(ds))

## ------------------------------------------------------------------------
identical(names(ds), aliases(variables(ds)))

## ------------------------------------------------------------------------
identical(names(ds), names(variables(ds)))

## ---- eval=FALSE---------------------------------------------------------
#  head(names(variables(ds)), 10)

## ---- echo=FALSE---------------------------------------------------------
head.of.variables

## ---- eval=FALSE---------------------------------------------------------
#  names(variables(ds))[6:9] <- c("Favorability of Edward Snowden",
#                                 "Approval of Snowden's Leak",
#                                 "Support for Prosecution of Snowden",
#                                 "Penalty for Snowden")
#  head(names(variables(ds)), 10)

## ---- echo=FALSE---------------------------------------------------------
head2

## ------------------------------------------------------------------------
is.Categorical(track.var)

## ---- eval=FALSE---------------------------------------------------------
#  categories(track.var)

## ---- echo=FALSE---------------------------------------------------------
track.cats.before

## ---- eval=FALSE---------------------------------------------------------
#  names(categories(track.var))

## ---- echo=FALSE---------------------------------------------------------
names(track.cats.before)

## ---- eval=FALSE---------------------------------------------------------
#  values(categories(track.var))

## ---- echo=FALSE---------------------------------------------------------
values(track.cats.before)

## ---- eval=FALSE---------------------------------------------------------
#  ids(categories(track.var))

## ---- echo=FALSE---------------------------------------------------------
ids(track.cats.before)

## ---- eval=FALSE---------------------------------------------------------
#  is.na(categories(track.var))

## ---- echo=FALSE---------------------------------------------------------
is.na(track.cats.before)

## ---- eval=FALSE---------------------------------------------------------
#  names(categories(track.var))[1:2] <- c("Right track", "Wrong track")
#  values(categories(track.var)) <- c(1, -1, 0)
#  is.na(categories(track.var)) <- "Not sure"
#  categories(track.var)

## ---- echo=FALSE---------------------------------------------------------
track.cats

## ---- eval=FALSE---------------------------------------------------------
#  ids(categories(track.var)) <- sample(ids(categories(track.var)), replace=FALSE)

## ---- eval=FALSE---------------------------------------------------------
#  categories(track.var) <- categories(track.var)[c(1,3,2)]
#  categories(track.var)

## ---- echo=FALSE---------------------------------------------------------
track.cats[c(1,3,2)]

## ---- eval=FALSE---------------------------------------------------------
#  ds <- hideVariables(ds, "comments")
#  hiddenVariables(ds)

## ---- eval=FALSE---------------------------------------------------------
#  hiddenVariables(ds) <- "pid7others"
#  hiddenVariables(ds)

## ----unhide, eval=FALSE--------------------------------------------------
#  ds <- unhideVariables(ds, "pid7others")
#  hiddenVariables(ds)

## ---- eval=FALSE---------------------------------------------------------
#  ds$votereg_old <- NULL

## ---- eval=FALSE---------------------------------------------------------
#  with(consent(), ds$votereg_old <- NULL)
#  "votereg_old" %in% names(ds)

