% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fork-and-merge.R
\name{forkDataset}
\alias{forkDataset}
\title{Create a fork of a dataset}
\usage{
forkDataset(
  dataset,
  name = defaultForkName(dataset),
  draft = FALSE,
  ...,
  project = defaultCrunchProject()
)
}
\arguments{
\item{dataset}{The \code{CrunchDataset} to fork}

\item{name}{character name to give the fork. If omitted, one will be provided
for you}

\item{draft}{logical: Should the dataset be a draft, visible only to
those with edit permissions? Default is \code{FALSE}.}

\item{...}{Additional dataset metadata to provide to the fork}

\item{project}{A \code{ProjectFolder} object, string path that could be passed to \code{\link[=cd]{cd()}}
relative to the root project, or a URL for a \code{ProjectFolder}. If left empty,
rcrunch will look in \code{envOrOption('crunch.default.project')} and error if nothing
is found.}
}
\value{
The new fork, a \code{CrunchDataset}.
}
\description{
Forking a dataset makes a copy of the data that is linked by Crunch's version
control system to the original dataset. When you make edits to a fork, users
of the original dataset do not see the changes.
}
\details{
A common strategy for revising a dataset that has been shared with others is
to fork it,
make changes to the fork, and then merge those changes back into the original
dataset.
This workflow allows you to edit a dataset and review changes before
publishing them, so that you don't accidentally send your clients
incorrect data. For more on this workflow, see
\code{vignette("fork-and-merge", package = "crunch")}.
}
\examples{
\dontrun{
# Defaults to being placed in the same project folder as the original dataset
ds_fork <- forkDataset(ds)

# But you can specify a project by path, `ProjectFolder` object or URL
ds_fork2 <- forkDataset(ds, project = "/Client1/forks/")
ds_fork3 <- forkDataset(ds, project = projects()[["My forks"]])
ds_fork4 <- forkDataset(ds, project = "https://app.crunch.io/api/projects/abc/")
}
}
\seealso{
\code{\link[=mergeFork]{mergeFork()}}
}
