% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-catalog.R, R/decks.R, R/filters.R,
%   R/members.R, R/multitables.R, R/permission-catalog.R, R/project-folder.R,
%   R/shoji-catalog.R, R/shoji-folder.R, R/slides.R, R/teams.R, R/user.R,
%   R/variable-catalog.R
\docType{methods}
\name{catalog-extract}
\alias{catalog-extract}
\alias{[[,DatasetCatalog,numeric-method}
\alias{[[<-,DatasetCatalog,character,missing,DatasetTuple-method}
\alias{[[,DeckCatalog,ANY-method}
\alias{[[,DeckCatalog,character-method}
\alias{[[,CrunchDeck,ANY-method}
\alias{[[<-,CrunchDeck,ANY,ANY,ANY-method}
\alias{[[,FilterCatalog,numeric-method}
\alias{[[<-,FilterCatalog,character,missing,CrunchLogicalExpr-method}
\alias{[[<-,FilterCatalog,numeric,missing,CrunchLogicalExpr-method}
\alias{[[<-,FilterCatalog,character,missing,CrunchFilter-method}
\alias{[[<-,FilterCatalog,numeric,missing,CrunchFilter-method}
\alias{[[,MemberCatalog,character-method}
\alias{[[<-,MemberCatalog,ANY,missing,ANY-method}
\alias{[[<-,MemberCatalog,character,missing,NULL-method}
\alias{[[,MultitableCatalog,numeric-method}
\alias{[[<-,MultitableCatalog,character,missing,formula-method}
\alias{[[<-,MultitableCatalog,numeric,missing,formula-method}
\alias{[[<-,MultitableCatalog,ANY,missing,NULL-method}
\alias{[[,PermissionCatalog,character-method}
\alias{[[<-,ProjectFolder,character,missing,list-method}
\alias{[[<-,ProjectFolder,character,missing,ProjectFolder-method}
\alias{[,ShojiCatalog,character,ANY-method}
\alias{[,ShojiCatalog,numeric,ANY-method}
\alias{[,ShojiCatalog,logical,ANY-method}
\alias{[,ShojiCatalog,ANY,ANY-method}
\alias{[[,ShojiCatalog,ANY-method}
\alias{[[,ShojiCatalog,character-method}
\alias{$,ShojiCatalog-method}
\alias{$<-,ShojiCatalog-method}
\alias{[<-,ShojiCatalog,ANY,missing,ShojiCatalog-method}
\alias{[[,ShojiFolder,numeric-method}
\alias{[[,ShojiFolder,character-method}
\alias{[[,SlideCatalog,ANY-method}
\alias{[[<-,SlideCatalog,numeric,missing,CrunchSlide-method}
\alias{[[,CrunchSlide,ANY-method}
\alias{[[<-,CrunchSlide,ANY,ANY,ANY-method}
\alias{[[,AnalysisCatalog,ANY-method}
\alias{[[<-,AnalysisCatalog,numeric,missing,formula-method}
\alias{[[<-,AnalysisCatalog,numeric,missing,Analysis-method}
\alias{[[<-,AnalysisCatalog,numeric,missing,list-method}
\alias{[[,TeamCatalog,numeric-method}
\alias{[[<-,TeamCatalog,character,missing,list-method}
\alias{[[<-,TeamCatalog,character,missing,CrunchTeam-method}
\alias{[,UserCatalog,character,ANY-method}
\alias{[[,UserCatalog,character-method}
\alias{[[,VariableCatalog,numeric-method}
\alias{[[<-,VariableCatalog,character,missing,VariableTuple-method}
\alias{[[<-,VariableCatalog,character,missing,CrunchVariable-method}
\alias{[,VariableCatalog,VariableOrder,ANY-method}
\alias{[,VariableCatalog,VariableGroup,ANY-method}
\alias{[<-,VariableCatalog,VariableOrder,missing,VariableCatalog-method}
\alias{[<-,VariableCatalog,VariableGroup,missing,VariableCatalog-method}
\title{Extract and modify subsets of Catalog-type objects}
\usage{
\S4method{[[}{DatasetCatalog,numeric}(x, i, j, ...)

\S4method{[[}{DatasetCatalog,character,missing,DatasetTuple}(x, i,
  j) <- value

\S4method{[[}{DeckCatalog,ANY}(x, i, j, ...)

\S4method{[[}{DeckCatalog,character}(x, i, j, ...)

\S4method{[[}{CrunchDeck,ANY}(x, i, j, ...)

\S4method{[[}{CrunchDeck,ANY,ANY,ANY}(x, i, j) <- value

\S4method{[[}{FilterCatalog,numeric}(x, i, j, ...)

\S4method{[[}{FilterCatalog,character,missing,CrunchLogicalExpr}(x, i,
  j) <- value

\S4method{[[}{FilterCatalog,numeric,missing,CrunchLogicalExpr}(x, i,
  j) <- value

\S4method{[[}{FilterCatalog,character,missing,CrunchFilter}(x, i,
  j) <- value

\S4method{[[}{FilterCatalog,numeric,missing,CrunchFilter}(x, i,
  j) <- value

\S4method{[[}{MemberCatalog,character}(x, i, j, ...)

\S4method{[[}{MemberCatalog,ANY,missing,ANY}(x, i, j) <- value

\S4method{[[}{MemberCatalog,character,missing,`NULL`}(x, i, j) <- value

\S4method{[[}{MultitableCatalog,numeric}(x, i, j, ...)

\S4method{[[}{MultitableCatalog,character,missing,formula}(x, i,
  j) <- value

\S4method{[[}{MultitableCatalog,numeric,missing,formula}(x, i,
  j) <- value

\S4method{[[}{MultitableCatalog,ANY,missing,`NULL`}(x, i, j) <- value

\S4method{[[}{PermissionCatalog,character}(x, i, j, ...)

\S4method{[[}{ProjectFolder,character,missing,list}(x, i, j) <- value

\S4method{[[}{ProjectFolder,character,missing,ProjectFolder}(x, i,
  j) <- value

\S4method{[}{ShojiCatalog,character,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{ShojiCatalog,numeric,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{ShojiCatalog,logical,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{ShojiCatalog,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[[}{ShojiCatalog,ANY}(x, i, j, ...)

\S4method{[[}{ShojiCatalog,character}(x, i, j, ...)

\S4method{$}{ShojiCatalog}(x, name)

\S4method{$}{ShojiCatalog}(x, name) <- value

\S4method{[}{ShojiCatalog,ANY,missing,ShojiCatalog}(x, i, j) <- value

\S4method{[[}{ShojiFolder,numeric}(x, i, ..., drop = FALSE)

\S4method{[[}{ShojiFolder,character}(x, i, ..., drop = FALSE)

\S4method{[[}{SlideCatalog,ANY}(x, i, j, ...)

\S4method{[[}{SlideCatalog,numeric,missing,CrunchSlide}(x, i, j) <- value

\S4method{[[}{CrunchSlide,ANY}(x, i, j, ...)

\S4method{[[}{CrunchSlide,ANY,ANY,ANY}(x, i, j) <- value

\S4method{[[}{AnalysisCatalog,ANY}(x, i, j, ...)

\S4method{[[}{AnalysisCatalog,numeric,missing,formula}(x, i, j) <- value

\S4method{[[}{AnalysisCatalog,numeric,missing,Analysis}(x, i, j) <- value

\S4method{[[}{AnalysisCatalog,numeric,missing,list}(x, i, j) <- value

\S4method{[[}{TeamCatalog,numeric}(x, i, j, ...)

\S4method{[[}{TeamCatalog,character,missing,list}(x, i, j) <- value

\S4method{[[}{TeamCatalog,character,missing,CrunchTeam}(x, i, j) <- value

\S4method{[}{UserCatalog,character,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[[}{UserCatalog,character}(x, i, j, ...)

\S4method{[[}{VariableCatalog,numeric}(x, i, j, ...)

\S4method{[[}{VariableCatalog,character,missing,VariableTuple}(x, i,
  j) <- value

\S4method{[[}{VariableCatalog,character,missing,CrunchVariable}(x, i,
  j) <- value

\S4method{[}{VariableCatalog,VariableOrder,ANY}(x, i, j, ...,
  drop = TRUE)

\S4method{[}{VariableCatalog,VariableGroup,ANY}(x, i, j, ...,
  drop = TRUE)

\S4method{[}{VariableCatalog,VariableOrder,missing,VariableCatalog}(x, i,
  j) <- value

\S4method{[}{VariableCatalog,VariableGroup,missing,VariableCatalog}(x, i,
  j) <- value
}
\arguments{
\item{x}{a Catalog object}

\item{i}{which catalog elements to extract}

\item{j}{Invalid}

\item{...}{additional arguments (for example \code{secondary} a vector of elements to match
against like \code{emails(x)} or \code{owners(x)} by default this is \code{names(x)})}

\item{value}{For updating, an object of the appropriate class and size to
insert}

\item{drop}{Invalid}

\item{name}{for \code{$}, the same as \code{i} for \code{[[}}
}
\value{
A subset of \code{x} if extracting, otherwise \code{x} duly modified
}
\description{
Extract and modify subsets of Catalog-type objects
}
