% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-datasets.R, R/projects.R
\name{datasets}
\alias{datasets}
\alias{datasets<-}
\title{Get the dataset catalog}
\usage{
datasets(x = getAPIRoot())

datasets(x) <- value
}
\arguments{
\item{x}{a \code{ShojiObject}, such as a \code{CrunchProject}. If omitted,
the default value for \code{x} means that you will load the user's primary
dataset catalog.}

\item{value}{\code{CrunchDataset} for the setter}
}
\value{
An object of class \code{DatasetCatalog}. The setter returns the
project (or other object that contains a dataset catalog with the given
dataset added to it (via changing its owner to be
the specified object, \code{x}).
}
\description{
Get the dataset catalog
}
\examples{
\dontrun{
# Get the primary dataset catalog
mydatasets <- datasets()
# Can load a dataset from that
ds <- loadDataset(mydatasets[["Dataset name"]])
# Can use the same function to get the dataset catalog for a project
proj <- projects()[["Project name"]]
projdatasets <- datasets(proj)
# The assignment method lets you move a dataset to a project
datasets(proj) <- ds
}
}

