% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data-methods.R
\name{update,DataDual-method}
\alias{update,DataDual-method}
\title{Update method for the "DataDual" class}
\usage{
\S4method{update}{DataDual}(
  object,
  x,
  y,
  w,
  newCohort = TRUE,
  ID = (if (length(object@ID)) max(object@ID) else 0L) + seq_along(y),
  ...
)
}
\arguments{
\item{object}{the old \code{\linkS4class{DataDual}} object}

\item{x}{the dose level (one level only!)}

\item{y}{the DLT vector (0/1 vector), for all patients in this cohort}

\item{w}{the biomarker vector, for all patients in this cohort}

\item{newCohort}{logical: if TRUE (default) the new data are assigned 
to a new cohort}

\item{ID}{the patient IDs}

\item{\dots}{not used}
}
\value{
the new \code{\linkS4class{DataDual}} object
}
\description{
Add new data to the \code{\linkS4class{DataDual}} object
}
\examples{

# Create some data of class 'DataDual'
myData <- DataDual(x=c(0.1,0.5,1.5,3,6,10,10,10),
                   y=c(0,0,0,0,0,0,1,0),
                   w=rnorm(8),
                   doseGrid=c(0.1,0.5,1.5,3,6,
                              seq(from=10,to=80,by=2)))

## update the data with a new cohort
myData <- update(myData,
                 x=20,
                 y=c(0,1,1),
                 w=c(0.4,1.2,2.2))

}
\keyword{methods}
