% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{NextBestMTD-class}
\alias{NextBestMTD-class}
\alias{.NextBestMTD}
\title{The class with the input for finding the next best MTD estimate}
\description{
The class with the input for finding the next best MTD estimate
}
\section{Slots}{

\describe{
\item{\code{target}}{the target toxicity probability}

\item{\code{derive}}{the function which derives from the input, a vector of
posterior MTD samples called \code{mtdSamples}, the final next best MTD
estimate.}
}}

\examples{

# In the example below the MTD is defined as the dose for which prob(DLE)=0.33 and
# we will use the 25th quantile of the posterior of MTD as our next best dose.
mtdNextBest <- NextBestMTD(target=0.33,
                           derive=
                             function(mtdSamples){
                               quantile(mtdSamples, probs=0.25)
                             })


}
\keyword{classes}
