% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_controller.R
\name{crew_class_controller}
\alias{crew_class_controller}
\title{Controller class}
\description{
\code{R6} class for controllers.
}
\details{
See \code{\link[=crew_controller]{crew_controller()}}.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
client <- crew_client()
launcher <- crew_launcher_local()
controller <- crew_controller(client = client, launcher = launcher)
controller$start()
controller$push(name = "task", command = sqrt(4))
controller$wait()
controller$pop()
controller$terminate()
}

## ------------------------------------------------
## Method `crew_class_controller$new`
## ------------------------------------------------

if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
client <- crew_client()
launcher <- crew_launcher_local()
controller <- crew_controller(client = client, launcher = launcher)
controller$start()
controller$push(name = "task", command = sqrt(4))
controller$wait()
controller$pop()
controller$terminate()
}
}
\seealso{
Other controller: 
\code{\link{crew_controller}()}
}
\concept{controller}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{client}}{Router object.}

\item{\code{launcher}}{Launcher object.}

\item{\code{tasks}}{A list of \code{mirai::mirai()} task objects.}

\item{\code{pushed}}{Number of tasks pushed since the controller was started.}

\item{\code{popped}}{Number of tasks popped
since the controller was started.}

\item{\code{log}}{Tibble with per-worker metadata about tasks.}

\item{\code{error}}{Tibble of task results (with one result per row)
from the last call to \verb{map(error = "stop)}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_controller-new}{\code{crew_class_controller$new()}}
\item \href{#method-crew_class_controller-validate}{\code{crew_class_controller$validate()}}
\item \href{#method-crew_class_controller-empty}{\code{crew_class_controller$empty()}}
\item \href{#method-crew_class_controller-nonempty}{\code{crew_class_controller$nonempty()}}
\item \href{#method-crew_class_controller-resolved}{\code{crew_class_controller$resolved()}}
\item \href{#method-crew_class_controller-unresolved}{\code{crew_class_controller$unresolved()}}
\item \href{#method-crew_class_controller-unpopped}{\code{crew_class_controller$unpopped()}}
\item \href{#method-crew_class_controller-saturated}{\code{crew_class_controller$saturated()}}
\item \href{#method-crew_class_controller-start}{\code{crew_class_controller$start()}}
\item \href{#method-crew_class_controller-launch}{\code{crew_class_controller$launch()}}
\item \href{#method-crew_class_controller-scale}{\code{crew_class_controller$scale()}}
\item \href{#method-crew_class_controller-push}{\code{crew_class_controller$push()}}
\item \href{#method-crew_class_controller-map}{\code{crew_class_controller$map()}}
\item \href{#method-crew_class_controller-collect}{\code{crew_class_controller$collect()}}
\item \href{#method-crew_class_controller-pop}{\code{crew_class_controller$pop()}}
\item \href{#method-crew_class_controller-wait}{\code{crew_class_controller$wait()}}
\item \href{#method-crew_class_controller-summary}{\code{crew_class_controller$summary()}}
\item \href{#method-crew_class_controller-terminate}{\code{crew_class_controller$terminate()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-new"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-new}{}}}
\subsection{Method \code{new()}}{
\code{mirai} controller constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$new(client = NULL, launcher = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{client}}{Router object. See \code{\link[=crew_controller]{crew_controller()}}.}

\item{\code{launcher}}{Launcher object. See \code{\link[=crew_controller]{crew_controller()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{R6} controller object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
client <- crew_client()
launcher <- crew_launcher_local()
controller <- crew_controller(client = client, launcher = launcher)
controller$start()
controller$push(name = "task", command = sqrt(4))
controller$wait()
controller$pop()
controller$terminate()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the client.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-empty"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-empty}{}}}
\subsection{Method \code{empty()}}{
Check if the controller is empty.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$empty(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
A controller is empty if it has no running tasks
or completed tasks waiting to be retrieved with \code{push()}.
}

\subsection{Returns}{
\code{TRUE} if the controller is empty, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-nonempty"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-nonempty}{}}}
\subsection{Method \code{nonempty()}}{
Check if the controller is nonempty.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$nonempty(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
A controller is empty if it has no running tasks
or completed tasks waiting to be retrieved with \code{push()}.
}

\subsection{Returns}{
\code{TRUE} if the controller is empty, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-resolved"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-resolved}{}}}
\subsection{Method \code{resolved()}}{
Number of resolved \code{mirai()} tasks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$resolved()}\if{html}{\out{</div>}}
}

\subsection{Details}{
\code{resolved()} is cumulative: it counts all the resolved
tasks over the entire lifetime of the controller session.
}

\subsection{Returns}{
Non-negative integer of length 1,
number of resolved \code{mirai()} tasks.
The return value is 0 if the condition variable does not exist
(i.e. if the client is not running).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-unresolved"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-unresolved}{}}}
\subsection{Method \code{unresolved()}}{
Number of unresolved \code{mirai()} tasks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$unresolved()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Non-negative integer of length 1,
number of unresolved \code{mirai()} tasks.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-unpopped"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-unpopped}{}}}
\subsection{Method \code{unpopped()}}{
Number of resolved \code{mirai()} tasks available via \code{pop()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$unpopped()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Non-negative integer of length 1,
number of resolved \code{mirai()} tasks available via \code{pop()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-saturated"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-saturated}{}}}
\subsection{Method \code{saturated()}}{
Check if the controller is saturated.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$saturated(
  collect = NULL,
  throttle = NULL,
  controller = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collect}}{Deprecated in version 0.5.0.9003 (2023-10-02). Not used.}

\item{\code{throttle}}{Deprecated in version 0.5.0.9003 (2023-10-02). Not used.}

\item{\code{controller}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
A controller is saturated if the number of unresolved tasks
is greater than or equal to the maximum number of workers.
In other words, in a saturated controller, every available worker
has a task.
You can still push tasks to a saturated controller, but
tools that use \code{crew} such as \code{targets} may choose not to.
}

\subsection{Returns}{
\code{TRUE} if the controller is saturated, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-start"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-start}{}}}
\subsection{Method \code{start()}}{
Start the controller if it is not already started.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$start(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Register the mirai client and register worker websockets
with the launcher.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-launch"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-launch}{}}}
\subsection{Method \code{launch()}}{
Launch one or more workers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$launch(n = 1L, controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of workers to try to launch. The actual
number launched is capped so that no more than "\code{workers}"
workers running at a given time, where "\code{workers}"
is an argument of \code{\link[=crew_controller]{crew_controller()}}. The
actual cap is the "\code{workers}" argument minus the number of connected
workers minus the number of starting workers. A "connected"
worker has an active websocket connection to the \code{mirai} client,
and "starting" means that the worker was launched at most
\code{seconds_start} seconds ago, where \code{seconds_start} is
also an argument of \code{\link[=crew_controller]{crew_controller()}}.}

\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-scale"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-scale}{}}}
\subsection{Method \code{scale()}}{
Auto-scale workers out to meet the demand of tasks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$scale(throttle = TRUE, controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{throttle}}{\code{TRUE} to skip auto-scaling if it already happened
within the last \code{seconds_interval} seconds. \code{FALSE} to auto-scale
every time \code{scale()} is called. Throttling avoids
overburdening the \code{mirai} dispatcher and other resources.}

\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Methods \code{push()}, \code{pop()}, and \code{wait()} already invoke
\code{scale()} if the \code{scale} argument is \code{TRUE}.
For finer control of the number of workers launched,
call \code{launch()} on the controller with the exact desired
number of workers.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-push"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-push}{}}}
\subsection{Method \code{push()}}{
Push a task to the head of the task list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$push(
  command,
  data = list(),
  globals = list(),
  substitute = TRUE,
  seed = NULL,
  algorithm = NULL,
  packages = character(0),
  library = NULL,
  seconds_timeout = NULL,
  scale = TRUE,
  throttle = TRUE,
  name = NA_character_,
  save_command = FALSE,
  controller = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{command}}{Language object with R code to run.}

\item{\code{data}}{Named list of local data objects in the
evaluation environment.}

\item{\code{globals}}{Named list of objects to temporarily assign to the
global environment for the task.
This list should
include any functions you previously defined in the global
environment which are required to run tasks.
See the \code{reset_globals} argument
of \code{\link[=crew_controller_local]{crew_controller_local()}}.}

\item{\code{substitute}}{Logical of length 1, whether to call
\code{base::substitute()} on the supplied value of the
\code{command} argument. If \code{TRUE} (default) then \code{command} is quoted
literally as you write it, e.g.
\code{push(command = your_function_call())}. If \code{FALSE}, then \code{crew}
assumes \code{command} is a language object and you are passing its
value, e.g. \code{push(command = quote(your_function_call()))}.
\code{substitute = TRUE} is appropriate for interactive use,
whereas \code{substitute = FALSE} is meant for automated R programs
that invoke \code{crew} controllers.}

\item{\code{seed}}{Integer of length 1 with the pseudo-random number generator
seed to set for the evaluation of the task. Passed to the
\code{seed} argument of \code{set.seed()} if not \code{NULL}.
If \code{algorithm} and \code{seed} are both \code{NULL},
then the random number generator defaults to the
widely spaced worker-specific
L'Ecuyer streams as supported by \code{mirai::nextstream()}.
See \code{vignette("parallel", package = "parallel")} for details.}

\item{\code{algorithm}}{Integer of length 1 with the pseudo-random number
generator algorithm to set for the evaluation of the task.
Passed to the \code{kind} argument of \code{RNGkind()} if not \code{NULL}.
If \code{algorithm} and \code{seed} are both \code{NULL},
then the random number generator defaults to the
recommended widely spaced worker-specific
L'Ecuyer streams as supported by \code{mirai::nextstream()}.
See \code{vignette("parallel", package = "parallel")} for details.}

\item{\code{packages}}{Character vector of packages to load for the task.}

\item{\code{library}}{Library path to load the packages. See the \code{lib.loc}
argument of \code{require()}.}

\item{\code{seconds_timeout}}{Optional task timeout passed to the \code{.timeout}
argument of \code{mirai::mirai()} (after converting to milliseconds).}

\item{\code{scale}}{Logical, whether to automatically call \code{scale()}
to auto-scale workers to meet the demand of the task load. Also
see the \code{throttle} argument.}

\item{\code{throttle}}{\code{TRUE} to skip auto-scaling if it already happened
within the last \code{seconds_interval} seconds. \code{FALSE} to auto-scale
every time \code{scale()} is called. Throttling avoids
overburdening the \code{mirai} dispatcher and other resources.}

\item{\code{name}}{Optional name of the task.}

\item{\code{save_command}}{Logical of length 1. If \code{TRUE}, the controller
deparses the command and returns it with the output on \code{pop()}.
If \code{FALSE} (default), the controller skips this step to
increase speed.}

\item{\code{controller}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-map"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-map}{}}}
\subsection{Method \code{map()}}{
Apply a single command to multiple inputs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$map(
  command,
  iterate,
  data = list(),
  globals = list(),
  substitute = TRUE,
  seed = NULL,
  algorithm = NULL,
  packages = character(0),
  library = NULL,
  seconds_interval = 0.5,
  seconds_timeout = NULL,
  names = NULL,
  save_command = FALSE,
  error = "stop",
  warnings = TRUE,
  verbose = interactive(),
  scale = TRUE,
  throttle = TRUE,
  controller = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{command}}{Language object with R code to run.}

\item{\code{iterate}}{Named list of vectors or lists to iterate over.
For example, to run function calls
\code{f(x = 1, y = "a")} and \code{f(x = 2, y = "b")},
set \code{command} to \code{f(x, y)}, and set \code{iterate} to
\code{list(x = c(1, 2), y = c("a", "b"))}. The individual
function calls are evaluated as
\code{f(x = iterate$x[[1]], y = iterate$y[[1]])} and
\code{f(x = iterate$x[[2]], y = iterate$y[[2]])}.
All the elements of \code{iterate} must have the same length.
If there are any name conflicts between \code{iterate} and \code{data},
\code{iterate} takes precedence.}

\item{\code{data}}{Named list of constant local data objects in the
evaluation environment. Objects in this list are treated as single
values and are held constant for each iteration of the map.}

\item{\code{globals}}{Named list of constant objects to temporarily
assign to the global environment for each task. This list should
include any functions you previously defined in the global
environment which are required to run tasks.
See the \code{reset_globals} argument of \code{\link[=crew_controller_local]{crew_controller_local()}}.
Objects in this list are treated as single
values and are held constant for each iteration of the map.}

\item{\code{substitute}}{Logical of length 1, whether to call
\code{base::substitute()} on the supplied value of the
\code{command} argument. If \code{TRUE} (default) then \code{command} is quoted
literally as you write it, e.g.
\code{push(command = your_function_call())}. If \code{FALSE}, then \code{crew}
assumes \code{command} is a language object and you are passing its
value, e.g. \code{push(command = quote(your_function_call()))}.
\code{substitute = TRUE} is appropriate for interactive use,
whereas \code{substitute = FALSE} is meant for automated R programs
that invoke \code{crew} controllers.}

\item{\code{seed}}{Integer of length 1 with the pseudo-random number generator
seed to set for the evaluation of the task. Passed to the
\code{seed} argument of \code{set.seed()} if not \code{NULL}.
If \code{algorithm} and \code{seed} are both \code{NULL},
then the random number generator defaults to the
recommended widely spaced worker-specific
L'Ecuyer streams as supported by \code{mirai::nextstream()}.
See \code{vignette("parallel", package = "parallel")} for details.}

\item{\code{algorithm}}{Integer of length 1 with the pseudo-random number
generator algorithm to set for the evaluation of the task.
Passed to the \code{kind} argument of \code{RNGkind()} if not \code{NULL}.
If \code{algorithm} and \code{seed} are both \code{NULL},
then the random number generator defaults to the
recommended widely spaced worker-specific
L'Ecuyer streams as supported by \code{mirai::nextstream()}.
See \code{vignette("parallel", package = "parallel")} for details.}

\item{\code{packages}}{Character vector of packages to load for the task.}

\item{\code{library}}{Library path to load the packages. See the \code{lib.loc}
argument of \code{require()}.}

\item{\code{seconds_interval}}{Number of seconds to wait between intervals
polling the tasks for completion.}

\item{\code{seconds_timeout}}{Optional task timeout passed to the \code{.timeout}
argument of \code{mirai::mirai()} (after converting to milliseconds).}

\item{\code{names}}{Optional character of length 1, name of the element of
\code{iterate} with names for the tasks. If \code{names} is supplied,
then \code{iterate[[names]]} must be a character vector.}

\item{\code{save_command}}{Logical of length 1, whether to store
a text string version of the R command in the output.}

\item{\code{error}}{Character vector of length 1, choice of action if
a task has an error. Possible values:
\itemize{
\item \code{"stop"}: throw an error in the main R session instead of returning
a value. In case of an error, the results from the last errored
\code{map()} are in the \code{error} field
of the controller, e.g. \code{controller_object$error}. To reduce
memory consumption, set \code{controller_object$error <- NULL} after
you are finished troubleshooting.
\item \code{"warn"}: throw a warning. This allows the return value with
all the error messages and tracebacks to be generated.
\item \code{"silent"}: do nothing special.
}}

\item{\code{warnings}}{Logical of length 1, whether to throw a warning in the
interactive session if at least one task encounters an error.}

\item{\code{verbose}}{Logical of length 1, whether to print progress messages.}

\item{\code{scale}}{Logical, whether to automatically scale workers to meet
demand. See also the \code{throttle} argument.}

\item{\code{throttle}}{\code{TRUE} to skip auto-scaling if it already happened
within the last \code{seconds_interval} seconds. \code{FALSE} to auto-scale
every time \code{scale()} is called. Throttling avoids
overburdening the \code{mirai} dispatcher and other resources.}

\item{\code{controller}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\code{map()} cannot be used unless all prior tasks are
completed and popped. You may need to wait and then pop them
manually. Alternatively, you can start over: either call
\code{terminate()} on the current controller object to reset it, or
create a new controller object entirely.
}

\subsection{Returns}{
A \code{tibble} of results and metadata: one row per task
and columns corresponding to the output of \code{pop()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-collect"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-collect}{}}}
\subsection{Method \code{collect()}}{
Deprecated in version 0.5.0.9003 (2023-10-02).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$collect(throttle = NULL, controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{throttle}}{Deprecated in version 0.5.0.9003 (2023-10-02).}

\item{\code{controllers}}{Deprecated in version 0.5.0.9003 (2023-10-02).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-pop"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-pop}{}}}
\subsection{Method \code{pop()}}{
Pop a completed task from the results data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$pop(
  scale = TRUE,
  collect = NULL,
  throttle = TRUE,
  controllers = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scale}}{Logical of length 1,
whether to automatically call \code{scale()}
to auto-scale workers to meet the demand of the task load.
Scaling up on \code{pop()} may be important
for transient or nearly transient workers that tend to drop off
quickly after doing little work.
See also the \code{throttle} argument.}

\item{\code{collect}}{Deprecated in version 0.5.0.9003 (2023-10-02).}

\item{\code{throttle}}{\code{TRUE} to skip auto-scaling if it already happened
within the last \code{seconds_interval} seconds. \code{FALSE} to auto-scale
every time \code{scale()} is called. Throttling avoids
overburdening the \code{mirai} dispatcher and other resources.}

\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If not task is currently completed, \code{pop()}
will attempt to auto-scale workers as needed.
}

\subsection{Returns}{
If there is no task to collect, return \code{NULL}. Otherwise,
return a one-row \code{tibble} with the following columns.
\itemize{
\item \code{name}: the task name if given.
\item \code{command}: a character string with the R command if \code{save_command}
was set to \code{TRUE} in \code{push()}.
\item \code{result}: a list containing the return value of the R command.
\item \code{seconds}: number of seconds that the task ran.
\item \code{seed}: the single integer originally supplied to \code{push()},
\code{NA} otherwise. The pseudo-random number generator state
just prior to the task can be restored using
\code{set.seed(seed = seed, kind = algorithm)}, where \code{seed} and
\code{algorithm} are part of this output.
\item \code{algorithm}: name of the pseudo-random number generator algorithm
originally supplied to \code{push()},
\code{NA} otherwise. The pseudo-random number generator state
just prior to the task can be restored using
\code{set.seed(seed = seed, kind = algorithm)}, where \code{seed} and
\code{algorithm} are part of this output.
\item \code{error}: the first 2048 characters of the error message if
the task threw an error, \code{NA} otherwise.
\item \code{trace}: the first 2048 characters of the text of the traceback
if the task threw an error, \code{NA} otherwise.
\item \code{warnings}: the first 2048 characters. of the text of
warning messages that the task may have generated, \code{NA} otherwise.
\item \code{launcher}: name of the \code{crew} launcher where the task ran.
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-wait"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-wait}{}}}
\subsection{Method \code{wait()}}{
Wait for tasks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$wait(
  mode = "all",
  seconds_interval = 0.5,
  seconds_timeout = Inf,
  scale = TRUE,
  throttle = TRUE,
  controllers = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mode}}{Character of length 1: \code{"all"} to wait for all tasks to
complete, \code{"one"} to wait for a single task to complete.}

\item{\code{seconds_interval}}{Number of seconds to interrupt the wait
in order to scale up workers as needed.}

\item{\code{seconds_timeout}}{Timeout length in seconds waiting for tasks.}

\item{\code{scale}}{Logical, whether to automatically call \code{scale()}
to auto-scale workers to meet the demand of the task load.
See also the \code{throttle} argument.}

\item{\code{throttle}}{\code{TRUE} to skip auto-scaling if it already happened
within the last \code{seconds_interval} seconds. \code{FALSE} to auto-scale
every time \code{scale()} is called. Throttling avoids
overburdening the \code{mirai} dispatcher and other resources.}

\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The \code{wait()} method blocks the calling R session and
repeatedly auto-scales workers for tasks that need them.
The function runs until it either times out or the condition
in \code{mode} is met.
}

\subsection{Returns}{
A logical of length 1, invisibly. \code{TRUE} if the condition
in \code{mode} was met, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-summary"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-summary}{}}}
\subsection{Method \code{summary()}}{
Summarize the workers and tasks of the controller.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$summary(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame of summary statistics on the workers and tasks.
It has one row per worker websocket and the following columns:
\itemize{
\item \code{controller}: name of the controller.
.  * \code{worker}: integer index of the worker.
\item \code{tasks}: number of tasks which were completed by
a worker at the websocket and then returned by calling
\code{pop()} on the controller object.
\item \code{seconds}: total number of runtime and seconds of
all the tasks that ran on a worker connected to this websocket
and then were retrieved by calling \code{pop()} on the controller
object.
\item \code{errors}: total number of tasks which ran on a worker
at the website, encountered an error in R, and then retrieved
with \code{pop()}.
\item \code{warnings}: total number of tasks which ran on a worker
at the website, encountered one or more warnings in R,
and then retrieved with \code{pop()}. Note: \code{warnings}
is actually the number of \emph{tasks}, not the number of warnings.
(A task could throw more than one warning.
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-terminate}{}}}
\subsection{Method \code{terminate()}}{
Terminate the workers and the \code{mirai} client.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$terminate(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
}
