% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credsubs.R
\name{build.shiny.calc}
\alias{build.shiny.calc}
\title{Build a credible subset calculator}
\usage{
build.shiny.calc(
  credsubs.level,
  cov.space,
  name = "calc",
  dir = ".",
  title = "Credible Subsets Calculator",
  instructions = "Select a covariate point."
)
}
\arguments{
\item{credsubs.level}{An object of class \code{credsubs.level}.}

\item{cov.space}{A data frame whose rows are human-readable
covariate points corresponding to the entries
of \code{credsubs.level$level}.}

\item{name}{A character string indicating the name of the application.}

\item{dir}{The directory in which to place the application.}

\item{title}{A character string to be displayed as the application title.}

\item{instructions}{A character string to be displayed as instructions.
HTML allowed.}
}
\description{
This function builds a \code{shiny} application in the specified directory
that gives the maximum credible level at an entered covariate point.
}
\details{
The calculator creates a subdirectory according to \code{name} in
the directory specified by \code{dir}, and places in it files
\code{server.R}, \code{ui.R}, and \code{config.RData}. This application
requires the \code{shiny} package to run, and can be executed by passing
the directory path to \code{run.shiny.calc()}. The produced application
directory may be moved from its original location.
}
