% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_transformation.R
\name{log_trans}
\alias{log_trans}
\alias{log_vars}
\title{Logarithmic transformation}
\usage{
log_trans(
  dat,
  target,
  x_list = NULL,
  cor_dif = 0.01,
  ex_cols = NULL,
  note = TRUE
)

log_vars(dat, x_list = NULL, target = NULL, cor_dif = 0.01, ex_cols = NULL)
}
\arguments{
\item{dat}{A data.frame.}

\item{target}{The name of target variable.}

\item{x_list}{A list of x variables.}

\item{cor_dif}{The correlation coefficient difference with the target of logarithm transformed variable and original variable.}

\item{ex_cols}{Names of excluded variables. Regular expressions can also be used to match variable names. Default is NULL.}

\item{note}{Logical, outputs info. Default is TRUE.}
}
\value{
Log transformed data.frame.
}
\description{
\code{log_trans} is for logarithmic transformation
}
\examples{
dat = log_trans(dat = UCICreditCard, target = "default.payment.next.month",
x_list =NULL,cor_dif = 0.01,ex_cols = "ID", note = TRUE)
}
