% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/essential_algorithms.R
\name{entropy_weight}
\alias{entropy_weight}
\title{Entropy Weight Method}
\usage{
entropy_weight(dat, ID = NULL, pos_vars, neg_vars)
}
\arguments{
\item{dat}{A data.frame with independent variables.}

\item{ID}{The name of ID variable.}

\item{pos_vars}{Names or index of positive direction variables, the bigger the better.}

\item{neg_vars}{Names or index of negative direction variables, the smaller the better.}
}
\value{
A data.frame with weights of each variable.
}
\description{
\code{entropy_weight} is for calculating Entropy Weight.
}
\details{
Step1 Raw data normalization
Step2 Find out the total amount of contributions of all samples to the index Xj
Step3 Each element of the step generated matrix is transformed into the product of each element and the LN (element),
and the information entropy is calculated.
Step4 Calculate redundancy.
Step5 Calculate the weight of each index.
}
\examples{
entropy_weight(dat = ewm_data,ID = "ID",
              pos_vars = -c(7,11),
              neg_vars = c(7,11))
}
