% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mcmc_mix}
\alias{mcmc_mix}
\title{Markov chain Monte Carlo for discrete extreme value mixture distribution}
\usage{
mcmc_mix(
  x,
  u,
  xi1,
  xi2,
  sig,
  geo,
  cont,
  a_phi,
  b_phi,
  a_xi1,
  b_xi1,
  m_xi2,
  s_xi2,
  a_sig,
  b_sig,
  pcont,
  N = 20000L,
  thin = 100L,
  burnin = 20000L,
  print_freq = 10000L
)
}
\arguments{
\item{x}{Vector of positive integers, representing the data}

\item{u}{Scalar, initial value of the positive integer threshold}

\item{xi1}{Scalar, initial value of the parameter for values below or equal to u}

\item{xi2}{Scalar, initial value of the shape parameter of the integer generalised Pareto distribution (IGPD), for values above u}

\item{sig}{Scalar, initial value of the scale parameter of IGPD, for values above u}

\item{geo}{Boolean. If 'TRUE', the geometric distribution is used for the values below u. If 'FALSE', the discrete power law is used.}

\item{cont}{Boolean, whether the continuity constraint is imposed at u}

\item{a_phi, b_phi, a_xi1, b_xi1, m_xi2, s_xi2, a_sig, b_sig}{Scalars, representing the hyperparameters of the prior distributions of the respective parameters. See details for the specification of the priors.}

\item{pcont}{Scalar, between 0.0 and 1.0, representing the prior probability of the continuity constrained version, for model selection.}

\item{N}{Scalar, positive integer representing the length of the output chain i.e. the number of rows in the returned data frame}

\item{thin}{Scalar, positive integer representing the thinning in the MCMC}

\item{burnin}{Scalar, non-negative integer representing the burn-in of the MCMC}

\item{print_freq}{Scalar, positive integer representing the frequency of printing the sampled values}
}
\value{
A data frame containing N rows and 7 columns which represent (in this order) the 4 parameters (u, xi1, xi2, sig), the implied exceedance probability (phi), the log-posterior density (lpost), and whether the continuity constraint is imposed (cont).
}
\description{
\code{mcmc_mix} returns the samples from the joint posterior of the parameters (u, xi1, xi2, sig), for fitting the discrete extreme value mixture distribution (DEVMD) to the data x. The samples are obtained using Markov chain Monte Carlo (MCMC).
}
\details{
In the MCMC, a componentwise Metropolis-Hastings algorithm is used. Unlike \code{mcmc_upp}, the threshold u is treated as a parameter in \code{mcmc_mix} and therefore inferred. The 8 hyperparameters are used in the following priors: u is such that the implied exceedance probability phi ~ Uniform(a_phi, b_phi); xi1 ~ Uniform(a_xi1, b_xi1); xi2 ~ Normal(mean = m_xi2, sd = s_xi2); sig ~ Gamma(shape = a_sig, rate = b_sig). If pcont = 0.0, only the unconstrained version of the DEVMD is fitted; if pcont = 1.0, only the continuity constrained version is fitted. Setting pcont between 0.0 and 1.0 allows both versions to be fitted, if model selection between the two is of interest.
}
\seealso{
\code{\link{mcmc_upp}} for MCMC for the discrete power law.
}
