% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lithuania.R
\name{Lithuania}
\alias{Lithuania}
\title{Lithuania Class for downloading, cleaning and processing notification data}
\source{
\url{https://hub.arcgis.com/datasets/d49a63c934be4f65a93b6273785a8449_0}
}
\description{
Information for downloading, cleaning
and processing COVID-19 region level 1 and 2 data for Lithuania.
}
\section{OSP Data fields}{


The \href{https://osp.stat.gov.lt}{Official Statistics Portal} (OSP) provides
many data series in their table.

The full range of these vectors can be returned by setting
\code{all_osp_fields} to \code{TRUE}.

The following describes the data provided by the OSP.\tabular{ll}{
   field \tab description \cr
   \code{date} \tab the reporting day during which the events occurred or at the end of which the accounting was performed \cr
   \code{municipality_code} \code{*} \tab code of the municipality assigned to persons \cr
   \code{municipality_name} \code{+} \tab the name of the municipality assigned to the persons \cr
   \code{population} \tab population size according to the data of the beginning of 2021, according to the declared place of residence \cr
   \code{ab_pos_day} \tab Number of positive antibody test responses, days \cr
   \code{ab_neg_day} \tab Number of negative antibody test responses, days \cr
   \code{ab_tot_day} \tab Number of antibody tests, daily \cr
   \code{ab_prc_day} \tab Percentage of positive antibody test responses per day \cr
   \code{ag_pos_day} \tab Number of positive antigen test responses, daily \cr
   \code{ag_neg_day} \tab Number of negative antigen test responses, daily \cr
   \code{ag_tot_day} \tab Number of antigen tests, daily \cr
   \code{ag_prc_day} \tab Percentage of positive responses to antigen tests per day \cr
   \code{pcr_pos_day} \tab number of positive PCR test responses, daily \cr
   \code{pcr_neg_day} \tab Number of PCR test negative responses, daily \cr
   \code{pcr_tot_day} \tab number of PCR tests per day \cr
   \code{pcr_prc_day} \tab Percentage of positive PCR test responses per day \cr
   \code{dgn_pos_day} \tab Number of positive answers to diagnostic tests / tests, days \cr
   \code{dgn_neg_day} \tab Number of negative answers to diagnostic tests / tests, days \cr
   \code{dgn_prc_day} \tab Number of diagnostic examinations / tests, days \cr
   \code{dgn_tot_day} \tab Percentage of positive answers to diagnostic tests / tests per day \cr
   \code{dgn_tot_day_gmp} \tab Number of diagnostic examinations / tests of samples collected at mobile points, days \cr
   \code{daily_deaths_def1} \tab The number of new deaths per day according to the (narrowest) COVID death definition No. 1. \verb{#} \cr
   \code{daily_deaths_def2} \tab Number of new deaths per day according to COVID death definition No. 2. \verb{#} \cr
   \code{daily_deaths_def3} \tab Number of new deaths per day according to COVID death definition No. 3. \verb{#} \cr
   \code{daily_deaths_all} \tab Daily deaths in Lithuania (by date of death) \cr
   \code{incidence} + \tab Number of new COVID cases per day (laboratory or physician confirmed) \cr
   \code{cumulative_totals} + \tab Total number of COVID cases (laboratory or physician confirmed) \cr
   \code{active_de_jure} \tab Declared number of people with COVID \cr
   \code{active_sttstcl} \tab Statistical number of people with COVID \cr
   \code{dead_cases} \tab The number of dead persons who were ever diagnosed with COVID \cr
   \code{recovered_de_jure} \tab Declared number of recovered live persons \cr
   \code{recovered_sttstcl} \tab Statistical number of recovered live persons \cr
   \code{map_colors} \code{$} \tab The map colour-coding for the municipality, based on averages of test positivity and incidence per capita \cr
}


\code{*} The \code{municipality_code} is discarded since it does not correspond
to ISO-3166:2 codes used elsewhere in the package.

\code{+} These fields are renamed but returned unmodified.

\verb{#} Lithuania offers counts according to three
different definitions of whether a death is attributable to COVID-19.

\code{$} This field is not recalculated for counties and is deleted.
}

\section{Criteria for attributing deaths}{


Beginning in February 2021 the OSP publishes death counts according to
three different criteria, from most to least strictly attributed to
COVID-19.
\enumerate{
\item \emph{\code{of}} Number of deaths with COVID-19 (coronavirus infection) as
the leading cause of death. The indicator is calculated by summing
all registered records of medical form E106 (unique persons), in which
the main cause of death is IPC disease codes U07.1 or U07.2. Deaths
due to external causes are not included (ICD disease codes are V00-Y36,
or Y85-Y87, or Y89, or S00-T79, or T89-T98).
\item \emph{\code{with}} Number of deaths with COVID-19 (coronavirus infection) of
any cause of death.
The indicator is calculated by summing all registered records of the
medical form E106 (unique persons), in which the ICD disease codes
U07.1, U07.2, U07.3, U07.4, U07.5 are indicated as the main, direct,
intermediate cause of death or other important pathological condition,
or identified as related to COVID-19 disease (coronavirus infection).
Deaths due to external causes are not included (ICD disease codes
are V00-Y36, or Y85-Y87, or Y89, or S00-T79, or T89-T98).
\item \emph{\code{after}} Number of deaths from any cause of COVID-19 or COVID-19
deaths due to non-external causes within 28 days.
The indicator is calculated by summing all registered records of the
medical form E106 (unique persons), in which the ICD disease codes
U07.1, U07.2, U07.3, U07.4, U07 are indicated as the main, direct,
intermediate cause of death or other important pathological condition,
or identified as related to COVID-19 disease (coronavirus infection)
and all records of medical form E106 (unique individuals) where the
person died within the last 28 days after receiving a positive
diagnostic response to the SARS-CoV-2 test or had an entry in medical
form E025 with ICD disease code U07.2 or U07.1. Deaths due to external
causes are not included (ICD disease codes are V00-Y36, or Y85-Y87, or
Y89, or S00-T79, or T89-T98).
}

The number of deaths reported in the last day is preliminary and
increases by about 20-40\% in a few days. Such a "delay" in the data is
natural: for example, for those who died last night, a death certificate
is likely to be issued as soon as this report is published this morning.
}

\section{De jure and statistical counts}{


Beginning in February 2021 the OSP makes statistical estimates
of the number of recovered and active cases, since review of the data
showed that some cases individuals still considered as active cases
had recovered, but not documented or registered as such.

These are listed as by the OSP as \code{active_de_jure} and
\code{recovered_de_jure} (officially still considered sick),
and \code{active_sttstcl} and \code{recovered_sttstcl} (an estimate of how
many of these are still ill).
}

\examples{
\dontrun{
region <- Lithuania$new(verbose = TRUE, steps = TRUE, get = TRUE)
}
}
\seealso{
Subnational data sources
\code{\link{Belgium}},
\code{\link{Brazil}},
\code{\link{Canada}},
\code{\link{Colombia}},
\code{\link{Covid19DataHub}},
\code{\link{Cuba}},
\code{\link{France}},
\code{\link{Germany}},
\code{\link{Google}},
\code{\link{India}},
\code{\link{Italy}},
\code{\link{JHU}},
\code{\link{Mexico}},
\code{\link{Netherlands}},
\code{\link{SouthAfrica}},
\code{\link{Switzerland}},
\code{\link{UK}},
\code{\link{USA}}
}
\concept{dataset}
\concept{subnational}
\section{Super class}{
\code{\link[covidregionaldata:DataClass]{covidregionaldata::DataClass}} -> \code{Lithuania}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{origin}}{name of origin to fetch data for}

\item{\code{supported_levels}}{A list of supported levels.}

\item{\code{supported_region_names}}{A list of region names in order of level.}

\item{\code{supported_region_codes}}{A list of region codes in order of level.}

\item{\code{common_data_urls}}{List of named links to raw data that are common
across levels.}

\item{\code{source_data_cols}}{existing columns within the raw data}

\item{\code{source_text}}{Plain text description of the source of the data}

\item{\code{source_url}}{Website address for explanation/introduction of the
data}

\item{\code{death_definition}}{which criteria of deaths attributed to
COVID to use}

\item{\code{recovered_definition}}{whether to use the official counts of
recovered cases or the statistical estimates provided by OSP}

\item{\code{all_osp_fields}}{whether to return all the data vectors provided
by OSP}

\item{\code{national_data}}{whether to return data rows for national results}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-set_region_codes}{\code{Lithuania$set_region_codes()}}
\item \href{#method-clean_common}{\code{Lithuania$clean_common()}}
\item \href{#method-clean_level_1}{\code{Lithuania$clean_level_1()}}
\item \href{#method-new}{\code{Lithuania$new()}}
\item \href{#method-clone}{\code{Lithuania$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="available_regions">}\href{../../covidregionaldata/html/DataClass.html#method-available_regions}{\code{covidregionaldata::DataClass$available_regions()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="clean">}\href{../../covidregionaldata/html/DataClass.html#method-clean}{\code{covidregionaldata::DataClass$clean()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="download">}\href{../../covidregionaldata/html/DataClass.html#method-download}{\code{covidregionaldata::DataClass$download()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="filter">}\href{../../covidregionaldata/html/DataClass.html#method-filter}{\code{covidregionaldata::DataClass$filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="get">}\href{../../covidregionaldata/html/DataClass.html#method-get}{\code{covidregionaldata::DataClass$get()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="process">}\href{../../covidregionaldata/html/DataClass.html#method-process}{\code{covidregionaldata::DataClass$process()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="return">}\href{../../covidregionaldata/html/DataClass.html#method-return}{\code{covidregionaldata::DataClass$return()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="summary">}\href{../../covidregionaldata/html/DataClass.html#method-summary}{\code{covidregionaldata::DataClass$summary()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="test">}\href{../../covidregionaldata/html/DataClass.html#method-test}{\code{covidregionaldata::DataClass$test()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_region_codes"></a>}}
\if{latex}{\out{\hypertarget{method-set_region_codes}{}}}
\subsection{Method \code{set_region_codes()}}{
Set up a table of region codes for clean data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Lithuania$set_region_codes()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clean_common"></a>}}
\if{latex}{\out{\hypertarget{method-clean_common}{}}}
\subsection{Method \code{clean_common()}}{
Common data cleaning for both levels
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Lithuania$clean_common()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clean_level_1"></a>}}
\if{latex}{\out{\hypertarget{method-clean_level_1}{}}}
\subsection{Method \code{clean_level_1()}}{
Lithuania Specific County Level Data Cleaning

Aggregates data to the level 1 (county) regional level. Data is
provided by the source at the level 2 (municipality) regional level.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Lithuania$clean_level_1()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize the country
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Lithuania$new(
  death_definition = "of",
  recovered_definition = "official",
  all_osp_fields = FALSE,
  national_data = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{death_definition}}{A character string. Determines which criteria
for attributing deaths to COVID is used. Should be \code{"of"},
\code{"with"}, or \code{"after"}. Can also be \code{"daily_deaths_def1"},
\code{"daily_deaths_def2"}, or \code{"daily_deaths_def3"}. (Defaults
to \code{"of"}, the strictest definition.)}

\item{\code{recovered_definition}}{A character string. Determines whether
the count of officially-recovered (\emph{de jure}) cases is used, or
the statistical estimate provided by OSP. Should be \code{"official"}
or \code{"statistical"}. (Defaults to \code{"official"}.)}

\item{\code{all_osp_fields}}{A logical scalar. Should all the meaningful
data fields from the OSP source be returned? (Defaults \code{FALSE})}

\item{\code{national_data}}{A logical scalar. Should national values be
returned?  (Defaults \code{FALSE})}

\item{\code{...}}{Parameters passed to \code{\link[=DataClass]{DataClass()}} initalize}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Lithuania$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
