% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.STdata.R
\name{read.STdata}
\alias{read.STdata}
\title{Imports a text file in R}
\usage{
read.STdata(
  file,
  header = FALSE,
  dec = ".",
  sep = "",
  iclx,
  icly,
  iclt,
  icldate = c(icl.date = 0, iclty = 0, icltm = 0, icltd = 0),
  icltime = c(icl.time = 0, icltH = 0, icltM = 0, icltS = 0),
  iclvr,
  iclsp = 0,
  missing.v = NA,
  save.as = "data.frame",
  date.format = c("code", format = NA),
  bytime = NA,
  tlag,
  time.zone = ""
)
}
\arguments{
\item{file}{the name of the data file and its extension. The file is searched
in the current working directory, otherwise the absolute path has to be included
in the file name. Note that data for each spatial point and
each temporal point are given by row; each row of the file contains at least
the x and y coordinates of a spatial point, the temporal code (or date) and
the measurement of the variable of interest.}

\item{header}{logical, value indicating whether the file contains the names
of the variables in the first line. If this argument is missing, header is
set to \code{FALSE} (default choice)}

\item{dec}{character, used to indicate decimal points}

\item{sep}{field separator character. If sep = "" (default choice)
columns of the file are separated by white space or tabs (see \code{\link[utils]{read.table}}
for more details)}

\item{iclx}{numeric, the column in which the x-coordinate of the spatial points are
stored}

\item{icly}{numeric, the column in which the y-coordinate of the spatial points are
stored}

\item{iclt}{numeric, the column in which numeric temporal codes are stored.
This argument is provided  only if the \code{icldate} argument is not available:
\code{iclt} and \code{icldate}  are mutually exclusive. This argument is set
equal to \code{0}, if not available}

\item{icldate}{numeric vector to set the columns in which the dates are stored.
The user has to set \code{icl.date} if the date is stored in a single column, otherwise
the user has to specify the colunn in which the years (\code{iclty}), the months
(\code{icltm}) or the days (\code{icltd}) are stored separately.
This argument is set equal to \code{0} (default choice) if not available}

\item{icltime}{numeric vector to set the columns in which the time component
(hour, minute, second) of a date (if available) is stored. The user has to
set \code{icl.time} if the time is stored in a single column, otherwise the
user has to specify the column in which the hours (\code{icltH}), the minutes
(\code{icltM}) or the seconds (\code{icltS}) are stored separately.
This argument is set equal to \code{0} (default choice) if not available}

\item{iclvr}{numeric, the column in which the values of the variable are stored}

\item{iclsp}{numeric, the column in which the identification codes (IDs) for the
spatial locations are stored. This argument is set equal to \code{0} (default
choice) if IDs for the spatial locations are not available}

\item{missing.v}{code used to indicate the presence of missing values in
the imported data. By default this argument is set equal to \code{NA}}

\item{save.as}{character, indicating the class of the data to be returned.
It is allowed to choose between two options for saving the file (\code{"STFDF"}
or \code{"data.frame"})}

\item{date.format}{vector, whose first element \code{date.format[1]} denotes the class of
the temporal component to be imported and the second one \code{date.format[2]} represents
the corresponding format. Note that the supported class of dates are
\code{"yearmon"}, \code{"yearqtr"},
\code{"Date"}, \code{"POSIX"} (see \pkg{Base}, \pkg{lubridate}, \pkg{zoo});
moreover the personalized options \code{"year"} and \code{"code"} are also admissible and
are used if the temporal coordinate is given by year or as a numerical code,
respectively. By default, the argument \code{date.format} is set equal to \code{("code", format = NA)}.
If the temporal component, provided for example in year and month, is given in
separeted columns in the text file,
the required format in \code{date.format[2]} is of the type \code{"\%Y \%m"};
in general the format requires the use of white spaces between two consecutive time units}

\item{bytime}{character, which denotes the time disaggregation of interest,
set \code{NA} (default choice) for numeric temporal code, otherwise \code{"\%Y"}
or \code{"\%y"} if values are taken by year, \code{"\%m"} if values are taken by
month, \code{"\%d"} if values are taken by day, \code{"\%q"} if values
are taken by quarter, \code{"\%H"} if values are taken by hour, \code{"\%M"}
if values are taken by minute and \code{"\%S"} if values are taken by seconds}

\item{tlag}{numeric, time increment/lag between two temporal observations}

\item{time.zone}{character, time zone for dates with time component}
}
\value{
object of the \code{STFDF}-class or \code{data.frame}, which contains
coordinates of the spatial points, the spatial IDs, the temporal IDs, the dates
(if available in the input file) and the observed values of the variable of interest
}
\description{
A function for importing a text file containing spatio-temporal data.
In particular, it (a) generates the spatial and temporal IDs,
(b) converts the time series of each spatial point (with non-existing values
for some dates) into a regularly spaced object
within the observed time period, by filling the missing dates with ‘NA’
(c) converts the data into a \code{STFDF}, according to the standard of the
\code{spacetime} package, or into a data frame
}
\details{
{
\itemize{
\item Uncomplete time series, for each spatial point, are filled with NA
\item Some checks on the admissibility of the supported classes of dates are
implemented
\item Time indexes for temporal points are coded for data.frame output by using
consecutive numbers starting from 1 (column 'timeIndex')
\item The spatial points are coded by using the string 'id' and the consecutive numbers
starting from 1 (column 'spatialIndex')
}
}
}
\examples{
#example 1: import a text file, with dates stored in a single column (the 4th)
# and fill missing time points in monthly time series, with time lag equal to one


## Not run
## To run example 1 paste and copy the following lines (without the symbol '#')
## in the console:
#file_date <- system.file("extdata", "file_date.txt", package = "covatest")
#db.date <- read.STdata(file = file_date, header = TRUE, iclx = 2, icly = 3, iclt = 0,
#icldate = c(icl.date = 4, iclty = 0, icltm = 0, icltd = 0),
#icltime = c(icl.time = 0, icltH =0, icltM = 0, icltS = 0),
#iclvr = 5, iclsp = 1, missing.v = -99999, save.as = "data.frame",
#date.format = c("Date", "\%d-\%m-\%Y"), bytime = "\%m", tlag = 1)


#example 2: import a text file, with dates and times stored in different columns
# (from the 4th to the 9th) and fill missing time points in hourly time series,
# with time lag equal to three

## Not run
## To run example 2 paste and copy the following lines (without the symbol '#')
## in the console:
#file_datetime <- system.file("extdata", "file_datetime.txt", package = "covatest")
#db.datetime <- read.STdata(file = file_datetime, header = TRUE, iclx = 2, icly = 3, iclt = 0,
#icldate = c(icl.date = 0, iclty = 6, icltm = 5, icltd = 4),
#icltime = c(icl.time = 0, icltH = 7, icltM = 8, icltS = 9),
#iclvr = 10, iclsp = 1, missing.v = -99999, save.as = "data.frame",
#date.format = c("POSIX", "\%Y \%m \%d \%H \%M \%S"), bytime = "\%H", tlag = 3)


#example 3: import a text file, with dates and times stored in different columns
# (from the 4th to the 9th) and fill missing time points in quarterly time series,
# with time lag equal to one

## Not run
## To run example 3 paste and copy the following lines (without the symbol '#')
## in the console:
#file_yq <- system.file("extdata", "file_yq.txt", package = "covatest")
#db.yq <- read.STdata(file = file_yq, header = TRUE, iclx = 2, icly = 3, iclt = 0,
#icldate = c(icl.date = 4, iclty = 0, icltm = 0, icltd = 0),
#icltime = c(icl.time = 0, icltH =0, icltM = 0, icltS = 0),
#iclvr = 5, iclsp = 1, missing.v = -99999, save.as = "data.frame",
#date.format = c("yearqtr", "\%Y-Q\%q"), bytime = "\%q", tlag = 1)


}
\references{
Bivand, R. S., Pebesma, E., Gomez-Rubio, V., 2013,
\emph{Applied spatial data analysis with R}, Second edition. New York: Springer.
\url{https://asdar-book.org/}

Grolemund, G, Wickham, H., 2011, Dates and Times Made Easy with lubridate.
Journal of Statistical Software, \bold{40(3)} 1--25.

Pebesma, E.J., 2012, spacetime: Spatio-Temporal Data in R.
Journal of Statistical Software, \bold{51(7)} 1--30.

Zeileis, A., Grothendieck. G., 2005, zoo: S3 Infrastructure for Regular and
Irregular Time Series.
Journal of Statistical Software, \bold{14(6)} 1--27.
}
\seealso{
\code{\link[spacetime]{STFDF-class}}

\code{\link[utils]{read.table}}

\code{\link[zoo]{yearmon}}

\code{\link[zoo]{yearqtr}}

\code{\link[base]{Dates}} for dates without times

\code{\link[base]{DateTimeClasses}}

\code{\link[base]{timezones}} for OlsonNames
}
