% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/couples.R
\docType{class}
\name{couples-class}
\alias{couples-class}
\alias{couples}
\alias{show,couples-method}
\alias{couples-method}
\alias{show}
\alias{[,couples-method}
\alias{select}
\alias{summary,couples-method}
\alias{summary}
\title{Class "couples"}
\usage{
couples(
  sel.staz,
  sp.couples.in,
  t.couples.in,
  typetest = "sym",
  typecode = numeric()
)

\S4method{show}{couples}(object)

\S4method{[}{couples}(x, i, by.row = FALSE)

\S4method{summary}{couples}(object)
}
\arguments{
\item{sel.staz}{vector, the sequence of ID codes which denote the spatial
points to be analyzed}

\item{sp.couples.in}{two-column matrix: rows corresponding to the couples
of different spatial points, chosen among the ones fixed in \code{sel.staz}
argument, to be compared}

\item{t.couples.in}{vector of only positive (negative) temporal lags to be
analyzed. The corresponding negative (positive) temporal lags are included
authomatically for \code{typetest = "sym", "sep", "tnSep"}. If some temporal
lags, corresponding to some couples of spatial points, are not required for
the specific test, they can be set equal to zero, through the specific
\code{\link{setzero}} method}

\item{typetest}{character, set \code{typetest = "sym"} for symmetry test
(default choice), \code{typetest = "sep"} for separability test,
\code{typetest = "tnSep"} for type of non separability test,
\code{typetest = "productSum"} for the test on the product-sum class of models,
\code{typetest = "intProduct"} for the test on the integrated product class
of models, \code{typetest = "gneiting"} for the test on the Gneiting class
of models}

\item{typecode}{type of object, i.e. numeric() or character(), specifies the
type of codification of the spatial points in the \code{data frame} or in the
STFDF/STSDF}

\item{object}{object of class \code{couples} for methods \code{show} and \code{summary}}

\item{x}{object of class \code{couples} for method \code{extract}}

\item{i}{index specifing rows or columns of the slot \code{@couples.st}.
Rows or columns depending on the logical parameter \code{by.row} to be set}

\item{by.row}{logical, if \code{TRUE} rows of the slot \code{@couples.st} are
selected (the temporal lags associated to the i-th spatial couple are given).
If \code{FALSE} (the default) columns of the slot \code{@couples.st} are
selected. In particular, the spatial couples associated to the i-th temporal
lag (i >= 3, temporal lags are stored from the third column) are given}
}
\description{
A class for spatial points and the corresponding temporal lags to be
analyzed in order to test some covariance properties and some well known
classes of space-time covariance functions models
}
\details{
It is important to point out that:
\itemize{
\item both positive and negative temporal lags are automatically considered in
the slot \code{@couples.st} and \code{@tl.couples} for symmetry test (\code{typetest = "sym"}),
separability test (\code{typetest = "sep"}) and type of non separability tests
(\code{typetest = "tnSep"}). If the symmetry hyphotesis has not been rejected, only
positive temporal lags might be considered for the test on separability and type
of non separability (\code{typetest = "sep"} and \code{typetest = "tnSep"}), hence the
specific \code{\link{setzero}} method must be used to set the negative temporal
lags equal to zero

\item for \code{typetest = "tnSep"} the temporal lags should be chosen according to
the results of the sample non separability ratios, plotted through a boxplot
classified for temporal lags (see \linkS4class{sepindex} for more details)

\item for model tests (\code{typetest} equal to \code{"productSum"},
\code{"intProduct"} and \code{"gneiting"}), the number of analyzed spatial
points must be used to create at least 3 spatial couples or multiple of 3,
such that each triplet satisfies the condition
\eqn{$||\mathbf{h}_{1}||^{2\gamma}- ||\mathbf{h}_{2}||^{2\gamma} = ||\mathbf{h}_{2}||^{2\gamma}-||\mathbf{h}_{3}||^{2\gamma}$}{||h_1||^{2\gamma} - ||h_2||^{2\gamma} = ||h_2||^{2\gamma} - ||h_3||^{2\gamma}}
where \eqn{\gamma \in ]0,1]} only for \code{typetest = "intProduct"}
and \code{"gneiting"}.
The number of positive temporal lags must be at least 3, or multiple
of 3, too. The condition \eqn{$u_{1}^{2\alpha}-u_{2}^{2\alpha}=u_{2}^{2\alpha}-u_{3}^{2\alpha}$}{u_1^{2\alpha} - u_2^{2\alpha} = u_2^{2\alpha} - u_3^{2\alpha}}
where \eqn{\alpha \in ]0,1]} must be satisfied for each triplet
(only for \code{typetest = "intProduct"} and \code{"gneiting"}), as clarified
in Cappello et al., 2018. The values of \eqn{\gamma} and \eqn{\alpha} are usually fixed
equal to 0.5 or 1 according that the behavior near the origin of the spatial
and temporal marginal covariograms is linear or quadratic, respectively.
Note that for each spatial triplet and each temporal triplet, 6 contrasts can
be defined. However, for \code{typetest = "intProduct"} (test on the integrated
model) the user has to set arbitrarily one temporal lag equal to zero for each
spatial triplet in order to delete redundant contrasts, through the specific
\code{\link{setzero}} method
}
}
\section{Slots}{

\describe{
\item{\code{couples.st}}{matrix, in which the first two columns contain the
couples of spatial points (denoted with order numbers) to be analyzed
and the other columns the temporal lags associated with each spatial couples}

\item{\code{sel.staz}}{numeric or character, contains the ID codes of the
selected spatial points}

\item{\code{sp.couples}}{data.frame, contains the couples of order numbers
associated with the spatial points to be analyzed and the couples of the
ID codes}

\item{\code{tl.couples}}{numeric, contains the temporal lags associated to the
couples of the selected spatial points}

\item{\code{typetest}}{character; contains the code of the test to be performed}
}}

\note{
{
Errors occur if
\itemize{
\item some spatial points, given in the sequence at the beginning of the
function, have not been used to generate the couples of spatial points

\item there is at least one spatial couple with no specification of
temporal lags

\item no temporal lags have been specified

\item the number of spatial points fixed in \code{sel.staz} is less than 2

\item the construction of the \code{sp.couples.in} is not consistent with the
test to be performed
}
}
}
\examples{
sel.staz.sym <- c("DERP016", "DENW065", "DEHE051", "DETH026", "DENW063", "DENI019",
"DENW068", "DEHE046", "DEUB029", "DEBY047", "DETH061", "DESN049")

sp.couples.in.sym <- matrix(data = c("DERP016", "DENW065", "DEHE051", "DETH026",
"DENW063", "DENI019", "DENW068", "DEHE046", "DEUB029", "DEBY047", "DETH061", "DESN049"),
ncol = 2, byrow = TRUE)

t.couples.in.sym <- c(1, 2)

couples.sym <- couples(sel.staz = sel.staz.sym, sp.couples.in = sp.couples.in.sym,
t.couples.in = t.couples.in.sym, typetest = "sym", typecode = character())

### methods for couples
#1. show
couples.sym

#2. [ extract
couples.sym[3, by.row = FALSE]
couples.sym[3, by.row = TRUE]

#3. summary
summary(couples.sym)

}
\references{
Cappello, C., De Iaco, S., Posa, D., 2020, {covatest}: An {R} Package for
Selecting a Class of Space-Time Covariance Functions.
Journal of Statistical Software, \bold{94(1)} 1--42.
}
\seealso{
\code{\link{setzero}}
}
