% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covablocks.R
\docType{class}
\name{covablocks-class}
\alias{covablocks-class}
\alias{covablocks}
\alias{show,covablocks-method}
\alias{covablocks-class}
\title{Class "covablocks"}
\usage{
covablocks(stblocks, stpairs, typetest = 0)

\S4method{show}{covablocks}(object)
}
\arguments{
\item{stblocks}{object of class \code{blocks}}

\item{stpairs}{object of class \code{couples}, containing the spatial
points and the corresponding temporal lags to be analyzed}

\item{typetest}{integer; set \code{typetest=0} for symmetry test (default
choice), \code{typetest=1} for separability test, \code{typetest=2} for type
of non separability test, \code{typetest=3} for the test on the product-sum
class of models, \code{typetest=4} for the test on the integrated product
class of models, \code{typetest=5} for the test on the Gneiting class of
models}

\item{object}{object of class \code{covablocks} for method \code{show}}
}
\description{
A class for the sample spatio-temporal covariance for each block
of data to be computed for the selected spatial and temporal lags fixed
in \code{stpairs} (output from \code{couples}). Depending on the type of
test the empirical variance, the sample spatial and temporal marginal
covariances for each block of data are also computed. Moreover, the sample
covariances between the spatio-temporal covariances at the specified spatial
and temporal lags are determined.
}
\section{Slots}{

\describe{
\item{\code{mat.cova}}{matrix of sample spatio-temporal covariances for each block,
computed for the spatial and temporal lags given in \code{stpairs}
(object of class \code{couples})}

\item{\code{mat.cova.h}}{matrix of sample spatial marginal covariances
for the specified lags}

\item{\code{mat.cova.u}}{matrix of sample temporal marginal covariances
for the specified lags}

\item{\code{mat.cova.cova}}{matrix of sample covariances between space-time
covariances for each block, computed for the spatial and temporal lags given
in \code{stpairs} (object of class \code{couples})}

\item{\code{typetest}}{numeric; contains the code of the test to be performed}
}}

\note{
{
\itemize{
\item If \code{typetest} is equal to 0 (symmetry test) or 4 (test on the
integrated product class of models) \code{mat.cova.h} and \code{mat.cova.u}
are not available

\item If \code{typetest} is equal to 5 (test on the Gneiting class of models),
\code{mat.cova.h} is not available

\item If temporal lags in \code{stpairs} are not consistent with block length
(\code{lb}) in \code{stblocks}, an error message will be returned

\item If the proportion between the maximum temporal lag in \code{stpairs} and
the block length (\code{lb}) in \code{stblocks} is greater than 0.25 a warning
message will be returned since the covariance estimation might not be reliable
}
}
}
\examples{
sel.staz.sym <- c("DERP016", "DENW065", "DEHE051", "DETH026", "DENW063", "DENI019",
"DENW068", "DEHE046", "DEUB029", "DEBY047", "DETH061", "DESN049")

sp.couples.in.sym <- matrix(data = c("DERP016", "DENW065", "DEHE051", "DETH026",
"DENW063", "DENI019", "DENW068", "DEHE046", "DEUB029", "DEBY047", "DETH061", "DESN049"),
ncol = 2, byrow = TRUE)

t.couples.in.sym <- c(1, 2)

couples.sym <- couples(sel.staz = sel.staz.sym, sp.couples.in = sp.couples.in.sym,
t.couples.in = t.couples.in.sym, typetest = 0, typecode = character())

block.sym <- blocks(lb=40, ls=10, matdata = rr_13, pardata1 = 1, pardata2 = 1,
stpairs = couples.sym)

covabl.sym <- covablocks(stblocks = block.sym, stpairs = couples.sym, typetest = 0)

###method for covablock
#1. show
covabl.sym

}
\references{
Li, B., Genton, M.G., Sherman, M., 2007, A nonparametric assessment
of properties of spacetime covariance functions.
Journal of the American Statistical Association, \bold{102} 736--744.

De Iaco, S., Palma, M., Posa, D., 2016. A general procedure for selecting a
class of fully symmetric space-time covariance functions.
Environmentrics, \bold{27(4)} 212--224.

Cappello, C., De Iaco, S., Posa, D., 2017, Testing the type of
non-separability and some classes of covariance models for space-time data.
Stochastic Environmental Research and Risk Assessment,
doi 10.1007/s00477-017-1472-2
}
\seealso{
\linkS4class{blocks}

\linkS4class{couples}
}
