% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocks.R
\docType{class}
\name{blocks-class}
\alias{blocks-class}
\alias{blocks}
\title{Class "blocks"}
\usage{
blocks(lb, ls, matdata, stpairs)
}
\arguments{
\item{lb}{integer, length of each block. The number of terms in each block
must be greater than 5 and smaller than the quarter part of the length of
each time series}

\item{ls}{integer, number of overlapped data between two consecutive blocks.
The number of overlapped terms between two consecutive blocks must in the
interval [0,lb/2]}

\item{matdata}{STFDF/STSDF or \code{data frame}; which contains the
coordinates of the spatial points, the identification code of the spatial
points, the indentification code of the temporal points and the values of
the variable, typically output from \code{dataprep}}

\item{stpairs}{object of class \code{couples}, containing the spatial
points and the corresponding temporal lags to be analyzed}
}
\description{
A class for overlapped blocks of the time series associated with the given
spatial points specified in \code{couples}. Thus, it is necessary to
execute \linkS4class{couples} first and then \linkS4class{blocks}
}
\details{
The function requires the user to set some external arguments. In particular,
if the spatio-temporal data are given as a \code{data} \code{frame} it is
necessary to specify
\itemize{
\item the column in which the spatial ID is stored
\item the column in which the values of the variable are stored.
}
On the other hand, if the data are given as a STFDF/STSDF it is necessary to
specify
\itemize{
\item the number of variables in the STFDF/STSDF
\item the slot in which the values of the variable of interest are stored
(only if more than one variable is stored in the STFDF/STSDF).
}

Moreover, a message informs the user of the number of blocks computed. The
user can choose to continue or not with this number of blocks.
}
\section{Slots}{

\describe{
\item{\code{mat.block}}{matrix of dimension (\emph{lb} x \emph{overall
number of blocks}); the columns of this matrix are associated with the
different blocks, of length equal to \code{lb}, that can be extracted
from the time series related to the selected spatial points
defined in \code{stpairs@sel.staz}}

\item{\code{array.block}}{array of dimension (\emph{lb} x \emph{number of
blocks for each selected spatial points} x \emph{number of spatial points}).
In each table of this array, the overlapped blocks for each spatial location
are available}
}}

\note{
\itemize{
\item "Error in matdata[, clvr]: subscript out of bounds" appears if the
second external arguments required for the given \code{data} \code{frame}
does not exist in the argument \code{matdata}

\item If "Error in matdata[, clvr]" appears, no data for some of the
spatial points, specified in \code{stpairs}, are available. The user has to
go back to \code{couples} and revise the vector of the selected spatial points

\item A stop running message occurs if the length of the time series for each
spatial points is less than 29

\item A message appears if the length of the time series for each
spatial point is greater than 29 and less than 89, since the length of the
time series is low and may not guarantee the reliability of the tests

\item If, in the last block of each selected spatial point, more than 15\%
of data are missing a warning message appears, since the estimation of the
covariance matrix, when a large number of missing values occurs, is not
reliable

\item A warning message appears if the number of blocks, computed by fixing
\code{lb} and \code{ls}, is less than 5. It is convenient that the number of
blocks is close to the number of spatio-temporal comparisons defined in
\code{couples}. This avoids singolarity in computing test statistics
}
}
\examples{
# In the example regarding the simmetry test (typetest = 0), the length of
# each block is equal to 40 (lb=40) and the number of overlapped data between
# two consecutive blocks is equal to 10 (ls=10). In this way, 24 blocks, for
# each time series of 730 data have been obtained [24 = (730 - 1) / (40 - 10)].
# This number of blocks is consistent with respect the number of comparisons
# (24) defined in couples. Moreover, it is necessary to specify some external
# arguments: the number of variables in the analyzed STFDF (rr_13) and to
# confirm whether or not one wants to proceed
# with the number of blocks obtained with the aforementioned combination of
# lb and ls
#
# To run the example, paste and copy the following lines
# (without the symbol '#') in the console
#
# coupl_sim <- couples(typetest = 0, typecode = character())
# blocks_sim <- blocks(lb = 40, ls = 10, matdata = rr_13, stpairs = coupl_sim)
# 1
# Y

}
\references{
Li, B., Genton, M.G., Sherman, M., 2007, A nonparametric assessment
of properties of spacetime covariance functions.
Journal of the American Statistical Association, \bold{102} 736--744.

De Iaco, S., Palma, M., Posa, D., 2016. A general procedure for selecting a
class of fully symmetric space-time covariance functions.
Environmentrics, \bold{27(4)} 212--224.

Cappello, C., De Iaco, S., Posa, D., 2016, Testing the type of
non-separability and some classes of covariance models for space-time data.
(submitted)
}
\seealso{
\code{\link{couples}}

\code{\link{dataprep}}
}
