% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ahmad2017.R
\name{Ahmad2017}
\alias{Ahmad2017}
\title{Test of Homogeneity of Covariance Matrices given by Ahmad 2017}
\usage{
Ahmad2017(x, ...)
}
\arguments{
\item{x}{data as a data frame, list of matrices, grouped data frame, or resample object}

\item{...}{other options passed to covTest method}
}
\value{
A list with class "htest" containing the following components:

\tabular{ll}{
\code{statistic} \tab the value of homogeneity of covariance test statistic \cr
\tab \cr
\code{parameter} \tab the degrees of freedom for the chi-squared statistic \cr
\tab \cr
\code{p.value} \tab the p=value for the test \cr
\tab \cr
\code{estimate} \tab the estimated covariances if less than 5 dimensions \cr
\tab \cr
\code{null.value} \tab the specified hypothesized value of the covariance difference \cr
\tab \cr
\code{alternative} \tab a character string describing the alternative hyposthesis \cr
\tab \cr
\code{method} \tab a character string indicating what type of homogeneity of covariance test was performed \cr
\tab \cr
\code{data.name} \tab a character string giving the names of the data
}
}
\description{
Test of Homogeneity of Covariance Matrices given by Ahmad 2017
}
\details{
The \code{\link{homogeneityCovariances}} function is a wrapper function that formats the data 
  for the specific \code{covTest} functions.
}
\examples{
irisSpecies <- unique(iris$Species)

iris_ls <- lapply(irisSpecies, 
    function(x){as.matrix(iris[iris$Species == x, 1:4])}
                 )
                 
names(iris_ls) <- irisSpecies

Ahmad2017(iris_ls)
}
\references{
Ahmad, R. (2017). Location-invariant test of homogeneity of large-dimensional covariance matrices. Journal of Statistical Theory and Practice, 11(4):731-745. \doi{10.1080/15598608.2017.1308895}
}
