% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching_distance_cache.R
\name{update_constraints}
\alias{update_constraints}
\title{Update Constraints on Distance Object}
\usage{
update_constraints(dist_obj, max_distance = Inf, calipers = NULL)
}
\arguments{
\item{dist_obj}{A distance_object from \code{compute_distances()}}

\item{max_distance}{Maximum allowed distance (pairs with distance > max_distance become Inf)}

\item{calipers}{Named list of per-variable calipers}
}
\value{
A new distance_object with updated cost_matrix
}
\description{
Apply new constraints to a precomputed distance object without
recomputing the underlying distances. This is useful for exploring
different constraint scenarios quickly.
}
\details{
This function creates a new distance_object with modified constraints
applied to the cost matrix. The original distance_object is not modified.

Constraints:
\itemize{
\item \code{max_distance}: Sets cost to Inf for pairs exceeding this threshold
\item \code{calipers}: Per-variable restrictions (e.g., calipers = list(age = 5))
}

The function returns a new object rather than modifying in place,
following R's copy-on-modify semantics.
}
\examples{
left <- data.frame(id = 1:5, age = c(25, 30, 35, 40, 45))
right <- data.frame(id = 6:10, age = c(24, 29, 36, 41, 44))
dist_obj <- compute_distances(left, right, vars = "age")

# Apply constraints
constrained <- update_constraints(dist_obj, max_distance = 2)
result <- match_couples(constrained)

}
