% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_fun.R
\name{run_flood}
\alias{run_flood}
\title{Return flood metrics by county codes or state names}
\usage{
run_flood(county_cd = NULL, state = NULL, start_date, end_date,
  threshold = "Q2", flood_type = "flood", output = "both",
  weight = "Q2")
}
\arguments{
\item{county_cd}{Character vector with the county FIPS code(s)}

\item{state}{Character vector of state names. Used to obtain county FIPS
codes if county_cd is NULL}

\item{start_date}{Character string with the starting date, using "YYYY-MM-DD"
notation.}

\item{end_date}{Character string with the end date, using "YYYY-MM-DD"
notation.}

\item{threshold}{Character string of the flood threshold to be used in the
analysis (either "Q2" or "NWS"). Defaults to "Q2".}

\item{flood_type}{Character string of the defined flood type based on NWS
classifications (one of "action", "flood", "moderate", or "major")}

\item{output}{Character string of output summary type (either "gage",
"county", or "both"). Defaults to "both".}

\item{weight}{Character string of variable to be used to scale by river size
for weighted averages and scaling point sizes on maps. Options are median
annual flood ("Q2") or drainage area ("DA"). Defaults to "Q2".}
}
\value{
A data frame with output at either the gage or county level,
  depending on the value of "output". If output = "gage" a data frame with
  the following columns is returned:

  \tabular{lll}{
  Name \tab Type \tab Description\cr
  site_no \tab character \tab USGS gage ID\cr
  county_cd \tab character \tab FIPS code of gage county location\cr
  lat \tab numeric \tab Gage latitude\cr
  long \tab numeric \tab Gage longitude\cr
  avg_peak \tab numeric \tab Mean flood ratio for date range
     (discharge/flood threshold)\cr
  flood_dur \tab numeric \tab Number of days in date range
     discharge above flood threshold\cr
  max_peak \tab numeric \tab Maximum value of flood ratio for date
     range (discharge/flood threshold)\cr
  num_missing \tab numeric \tab Number of days in given date
     range with no discharge data at that gage\cr
  Q2 \tab numeric \tab Median annual discharge (cubic feet per second)\cr
  DA \tab numeric \tab Drainage area of the gage (square miles)\cr
  size \tab numeric \tab Relative river size, logarithm of either Q2 or DA
     depending on user specified \code{weight}\cr
  state \tab character \tab State name\cr
  county \tab character \tab County name\cr
  flood \tab character \tab Flood magnitude category based on peak }

  If output = "county" a data frame with the following columns is returned:

  \tabular{lll}{
  Name \tab Type \tab Description\cr
  county \tab character \tab County name\cr
  state \tab character \tab State name\cr
  num_gage \tab numeric \tab Number of analyzed gages in county\cr
  avg_peak \tab numeric \tab Average flood ratio among county gages\cr
  max_peak \tab numeric \tab Maximum observed flood ratio\cr
  minor \tab numeric \tab Percentage of gages at or above "minor" flood
     class (flood ratio > 1)\cr
  moderate \tab numeric \tab Percentage of gages at or above "moderate"
     flood class (flood ratio > 1.5)\cr
  major \tab numeric \tab Percentage of gages at or above "major" flood
     class (flood ratio > 2)\cr
  extreme \tab numeric \tab Percentage of gages at or above "extreme"
     flood class (flood ratio > 5)\cr
  max_dur \tab numeric \tab Maximum flood duration in county\cr
  avg_dur \tab numeric \tab Average flood duration in county }

If threshold = "NWS", the columns "minor", "moderate", "major", and "extreme"
are replaced with two columns: "no_flood" and "yes_flood" which show the
percentage of gages in the county with or without flooding.

If output = "both" a list containing both data frames is returned.
In both cases, if data in counties were requested but not avaialable,
these counties are included as additional rows with data values of NA.
}
\description{
Access USGS databases to retrieve gages and flow data for the specified
counties/states or county FIPS codes and the specified date ranges. Flooding
at these gage locations are assessed by one of two metrics. Data can be
returned at the gage level or the county level.
}
\examples{
\dontrun{
#Use Q2 as flood threshold and get get gage-level output
va_floods <- run_flood(state = "Virginia", start_date = "2015-01-01",
                      end_date = "2015-12-31", threshold = "Q2",
                      output = "gage")

#Use NWS flood thresholds and get county-level output
va_floods <- run_flood(state = "Virginia", start_date = "2015-01-01",
                      end_date = "2015-12-31", threshold = "NWS",
                      flood_type = "action",
                      output = "county")
}
}
