% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_results.R
\name{map_county}
\alias{map_county}
\title{Maps flood data by county}
\usage{
map_county(county_stats, category = "minor", date = "")
}
\arguments{
\item{county_stats}{Data frame of flood analyasis results, summarized by
county.}

\item{category}{Character string of the flood magnitude category to be used
for mapping (one of "minor", "moderate", "major", or "extreme"). This
parameter only works when mapping county-level, rather than gage-level,
values.}

\item{date}{Date of data mapped to be printed at the top of the image. This
argument is used by the `time_series_map` function.}
}
\value{
A map of counties color coded by percentage of gages experiencing flooding.
}
\description{
Creates a state level map of flood analysis output by county. Counties are
color coded based on the percentage of gages in that county at or exceeding a
given flood magnitude.
}
