% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{gage_extract}
\alias{gage_extract}
\title{Get gage meta-data for a county}
\usage{
gage_extract(county_cd, start_date, end_date)
}
\arguments{
\item{county_cd}{Character vector with the county FIPS code}

\item{start_date}{Character string with the starting date, using "YYYY-MM-DD"
notation.}

\item{end_date}{Character string with the end date, using "YYYY-MM-DD"
notation.}
}
\value{
A dataframe with information about stream gages within a county for
   a specified time frame. This information typically includes each gage's
   site number, station name, agency code, site type code, latitude,
   longitude, and county code. See the \code{whatNWISsites} function from
   the \code{dataRetrieval} package for details.
}
\description{
This function uses the \code{whatNWISsites} function from the
\code{dataRetrieval} package to pull information on all stream gages within
a county and then adds the county FIPS code as an additional column to the
dataframe.
}
\examples{

gage_extract("12086", start_date = "2000-01-01", end_date = "2009-12-31")

}
\seealso{
\code{\link[dataRetrieval]{whatNWISsites}}
}
