% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costprop.R
\name{predict.costprop}
\alias{predict.costprop}
\title{Predict method for Cost-Proportionate Classifier}
\usage{
\method{predict}{costprop}(object, newdata, aggregation = "raw",
  output_type = "score", ...)
}
\arguments{
\item{object}{An object of class `costprop` as output by function `cost.proportionate.classifier`.}

\item{newdata}{New data on which to make predictions.}

\item{aggregation}{One of "raw" (will take the class according to votes from each classifier. The predictions from
classifiers must in turn be 1-dimensional vectors with the predicted class, not probabilities, scores, or two-dimensional
arrays - in package `caret` for example, this corresponds to `type = "raw"`), or "weighted" (will take a weighted
vote according to the probabilities or scores predicted by each classifier. The predictions from classifiers must in turn
be either 1-dimensional vectors with the predicted probability/score, or two-dimensional matrices with the second
column having the probability/score for the positive class = in package `caret` for example, this corresponds to `type = "prob`).}

\item{output_type}{One of "class" (will output the predicted class) or "score" (will output the predicted score).}

\item{...}{Additional arguments to pass to the predict method of the base classifier.}
}
\description{
Predicts either the class or score according to predictions from classifiers fit to different
resamples each. Be aware that the base classifier with which it was built must provide appropriate outputs
that match with the arguments passed here (`type` and `criterion`). This is usually managed through argument
`type` that goes to its `predict` method.
}
\examples{
\dontrun{
library(costsensitive)
data(iris)
set.seed(1)
X <- X <- iris[, c("Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width")]
y <- factor(iris$Species == "setosa", labels = c("class1", "class2"))
weights <- rgamma(100, 1)
classifier <- caret::train
model <- cost.proportionate.classifier(X, y, weights, classifier,
  method = "glm", family = "binomial",
  trControl=caret::trainControl(method="none"), tuneLength=1)
predict(model, X, aggregation = "raw", type = "raw")
predict(model, X, aggregation = "weighted", type = "prob")
}
}
